package com.instabug.apm.cache.model;

import static com.instabug.apm.util.flag_ext.ByteFlagExtKt.addFlag;
import static com.instabug.apm.util.flag_ext.ByteFlagExtKt.hasFlag;
import android.annotation.SuppressLint;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.apm.webview.webview_trace.model.WebViewCacheModel;
import java.util.List;

@SuppressLint("ERADICATE_FIELD_NOT_INITIALIZED")
public class UiTraceCacheModel {
    private long id = -1;
    private boolean userDefined;
    @Nullable
    private String name;
    private long duration;
    private long largeDropsDuration;
    private long smallDropsDuration;
    private long startTime;
    private int refreshRate;

    @Nullable
    private String screenTitle = null;
    private int batteryLevel = -1;
    @Nullable
    private Boolean powerSaveMode = null;
    @Nullable
    private String containerName = null;
    @Nullable
    private String moduleName = null;
    @Nullable
    private String orientation = null;
    @Nullable
    private String sessionId;
    @Nullable
    private UiLoadingModel uiLoadingModel = null;

    @Nullable
    private List<WebViewCacheModel> webViewTraces = null;

    private long startTimeInMicros;

    private byte currentCacheState;
    public static final byte UI_TRACE_INSERTED = 0b001;
    public static final byte UI_LOADING_INSERTED = 0b010;
    public static final byte COUNTS_UPDATED = 0b100;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Nullable
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    public String getScreenTitle() {
        return screenTitle;
    }

    public void setScreenTitle(String screenTitle) {
        this.screenTitle = screenTitle;
    }

    public int getBatteryLevel() {
        return batteryLevel;
    }

    public void setBatteryLevel(int batteryLevel) {
        this.batteryLevel = batteryLevel;
    }

    public int getRefreshRate() {
        return refreshRate;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
    }

    @Nullable
    public Boolean getPowerSaveMode() {
        return powerSaveMode;
    }

    public void setPowerSaveMode(@Nullable Boolean powerSaveMode) {
        this.powerSaveMode = powerSaveMode;
    }

    public long getStartTimestamp() {
        return startTime;
    }

    public void setStartTimestamp(long startTime) {
        this.startTime = startTime;
    }

    public long getDuration() {
        return duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getLargeDropsDuration() {
        return largeDropsDuration;
    }

    public void setLargeDropsDuration(long largeDropsDuration) {
        this.largeDropsDuration = largeDropsDuration;
    }

    public long getSmallDropsDuration() {
        return smallDropsDuration;
    }

    public void setSmallDropsDuration(long smallDropsDuration) {
        this.smallDropsDuration = smallDropsDuration;
    }

    public void setUiHangsModel(@Nullable UiHangModel uiHangsModel) {
        if (uiHangsModel != null) {
            this.largeDropsDuration = uiHangsModel.getLargeDropsDuration();
            this.smallDropsDuration = uiHangsModel.getSmallDropsDuration();
        } else {
            this.largeDropsDuration = -1;
            this.smallDropsDuration = -1;
        }
    }

    @Nullable
    public String getContainerName() {
        return containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    @Nullable
    public String getModuleName() {
        return moduleName;
    }

    public void setModuleName(@Nullable String moduleName) {
        this.moduleName = moduleName;
    }

    @Nullable
    public String getOrientation() {
        return orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public boolean isUserDefined() {
        return userDefined;
    }

    public void setUserDefined(boolean userDefined) {
        this.userDefined = userDefined;
    }

    public long getStartTimeInMicros() {
        return startTimeInMicros;
    }

    public void setStartTimeInMicros(long startTimeInMicros) {
        this.startTimeInMicros = startTimeInMicros;
    }

    @Nullable
    public String getSessionId() {
        return sessionId;
    }

    public void setSessionId(@Nullable String sessionId) {
        this.sessionId = sessionId;
    }

    @Nullable
    public UiLoadingModel getUiLoadingModel() {
        return uiLoadingModel;
    }

    public void setUiLoadingModel(@Nullable UiLoadingModel uiLoadingModel) {
        this.uiLoadingModel = uiLoadingModel;
    }

    private boolean hasUiLoadingModel() {
        return uiLoadingModel != null;
    }

    @Nullable
    public List<WebViewCacheModel> getWebViewTraces() {
        return webViewTraces;
    }

    public void setWebViewTraces(@Nullable List<WebViewCacheModel> webViewTraces) {
        this.webViewTraces = webViewTraces;
    }

    private boolean hasWebViewCacheModel() {
        return webViewTraces != null && !webViewTraces.isEmpty();
    }

    private boolean hasUiHangsModel() {
        return smallDropsDuration != -1 && largeDropsDuration != -1;
    }

    public boolean isModelValid() {
        return hasUiLoadingModel() || hasUiHangsModel() || hasWebViewCacheModel();
    }

    public int getWebViewTraceCount() {
        return webViewTraces != null ? webViewTraces.size() : 0;
    }

    public void setCurrentCacheState(byte currentCacheState) {
        this.currentCacheState = currentCacheState;
    }

    public void updateCacheState(byte flag) {
        this.currentCacheState = addFlag(this.currentCacheState, flag);
    }

    public boolean cacheStateIncludes(byte flag){
        return hasFlag(this.currentCacheState,flag);
    }

    public byte getCurrentCacheState() {
        return currentCacheState;
    }

    @NonNull
    @Override
    public String toString() {
        // To print visualized logs
        return "\nScrName:\t" + name +
                "\nScrTitle:\t" + screenTitle +
                "\nScrStTime:\t" + startTime +
                "\nScrVisit:\t" + duration +
                "\nSmallDrops:\t" + smallDropsDuration +
                "\nLargeDrop:\t" + largeDropsDuration +
                "\nRefresh:\t" + refreshRate +
                "\nPowerSave:\t" + powerSaveMode +
                "\nContainer:\t" + containerName +
                "\nModule:\t\t" + moduleName +
                "\nOrientat:\t" + orientation +
                "\nUserDefine:\t" + orientation +
                "\nBattery:\t" + batteryLevel +
                "\nSession:\t" + sessionId;
    }
}
