package com.instabug.apm.cache.model;

public class SessionMetaData {

    private int appLaunchesTotalCount;
    private int networkLogsTotalCount;
    private int uiTracesTotalCount;
    private int appLaunchesDroppedCount;
    private int networkLogsDroppedCount;
    private int uiTracesDroppedCount;
    private int fragmentSpansTotalCount;
    private int fragmentSpansDroppedCountRequestLimit;
    private int composeSpansTotalCount;
    private int composeSpansDroppedCountRequestLimit;
    private int webViewTracesTotalCount;
    private int webViewTracesDroppedCountRequestLimit;
    private int appFlowTotalCount;
    private int appFlowDroppedCountRequestLimit;

    public int getAppLaunchesTotalCount() {
        return appLaunchesTotalCount;
    }

    public void setAppLaunchesTotalCount(int appLaunchesTotalCount) {
        this.appLaunchesTotalCount = appLaunchesTotalCount;
    }

    public int getNetworkLogsTotalCount() {
        return networkLogsTotalCount;
    }

    public void setNetworkLogsTotalCount(int networkLogsTotalCount) {
        this.networkLogsTotalCount = networkLogsTotalCount;
    }

    public int getUiTracesTotalCount() {
        return uiTracesTotalCount;
    }

    public void setUiTracesTotalCount(int uiTracesTotalCount) {
        this.uiTracesTotalCount = uiTracesTotalCount;
    }

    public int getAppLaunchesDroppedCount() {
        return appLaunchesDroppedCount;
    }

    public void setAppLaunchesDroppedCount(int appLaunchesDroppedCount) {
        this.appLaunchesDroppedCount = appLaunchesDroppedCount;
    }

    public int getNetworkLogsDroppedCount() {
        return networkLogsDroppedCount;
    }

    public void setNetworkLogsDroppedCount(int networkLogsDroppedCount) {
        this.networkLogsDroppedCount = networkLogsDroppedCount;
    }

    public int getUiTracesDroppedCount() {
        return uiTracesDroppedCount;
    }

    public int getUiTracesDroppedCountStoreLimit(int storedUiTracesCount) {
        int remainingCount = uiTracesTotalCount - uiTracesDroppedCount;
        return remainingCount - storedUiTracesCount;
    }

    public void setUiTracesDroppedCount(int uiTracesDroppedCount) {
        this.uiTracesDroppedCount = uiTracesDroppedCount;
    }

    public int getFragmentSpansTotalCount() {
        return fragmentSpansTotalCount;
    }

    public void setFragmentSpansTotalCount(int fragmentSpansTotalCount) {
        this.fragmentSpansTotalCount = fragmentSpansTotalCount;
    }

    public int getFragmentSpansDroppedCountRequestLimit() {
        return fragmentSpansDroppedCountRequestLimit;
    }

    public void setFragmentSpansDroppedCountRequestLimit(int fragmentSpansDroppedCountRequestLimit) {
        this.fragmentSpansDroppedCountRequestLimit = fragmentSpansDroppedCountRequestLimit;
    }

    public int getFragmentSpansDroppedCountStoreLimit(int storedSpansCount) {
        int totalDroppedCount = fragmentSpansTotalCount - storedSpansCount;
        return totalDroppedCount - fragmentSpansDroppedCountRequestLimit;
    }

    public int getComposeSpansTotalCount() {
        return composeSpansTotalCount;
    }

    public void setComposeSpansTotalCount(int composeSpansTotalCount) {
        this.composeSpansTotalCount = composeSpansTotalCount;
    }

    public int getComposeSpansDroppedCountRequestLimit() {
        return composeSpansDroppedCountRequestLimit;
    }

    public void setComposeSpansDroppedCountRequestLimit(int composeSpansDroppedCountRequestLimit) {
        this.composeSpansDroppedCountRequestLimit = composeSpansDroppedCountRequestLimit;
    }

    public int getComposeSpansDroppedCountStoreLimit(int storedComposeSpansCount) {
        int totalDroppedCount = composeSpansTotalCount - storedComposeSpansCount;
        return totalDroppedCount - composeSpansDroppedCountRequestLimit;
    }

    public void setWebViewTracesTotalCount(int webViewTracesTotalCount) {
        this.webViewTracesTotalCount = webViewTracesTotalCount;
    }

    public int getWebViewTracesTotalCount() {
        return webViewTracesTotalCount;
    }

    public void setWebViewTracesDroppedCountRequestLimit(int webViewTracesDroppedCountRequestLimit) {
        this.webViewTracesDroppedCountRequestLimit = webViewTracesDroppedCountRequestLimit;
    }

    public int getWebViewTracesDroppedCountRequestLimit() {
        return webViewTracesDroppedCountRequestLimit;
    }

    public int getWebViewTracesDroppedCountStoreLimit(int storedWebViewTracesCount) {
        int totalDroppedCount = webViewTracesTotalCount - storedWebViewTracesCount;
        return totalDroppedCount - webViewTracesDroppedCountRequestLimit;
    }

    public int getAppFlowTotalCount() {
        return appFlowTotalCount;
    }

    public void setAppFlowTotalCount(int appFlowTotalCount) {
        this.appFlowTotalCount = appFlowTotalCount;
    }

    public int getAppFlowDroppedCountRequestLimit() {
        return appFlowDroppedCountRequestLimit;
    }

    public void setAppFlowDroppedCountRequestLimit(int appFlowDroppedCountRequestLimit) {
        this.appFlowDroppedCountRequestLimit = appFlowDroppedCountRequestLimit;
    }
}
