package com.instabug.apm.appflow.validate

import com.instabug.apm.appflow.model.AppFlowAttribute
import com.instabug.apm.sanitization.Sanitizer

class AppFlowAttributeSanitizer(
    private val appFlowNameSanitizer: Sanitizer<String?>
): Sanitizer<AppFlowAttribute> {

    override fun sanitize(item: AppFlowAttribute): AppFlowAttribute =
        AppFlowAttribute(
            name = appFlowNameSanitizer.sanitize(item.name),
            key = item.key?.trim(),
            value = item.value?.trim()
        )
}