package com.instabug.apm.appflow.log

internal const val PLACE_HOLDER = "%R"

internal const val FEATURE_BE_DISABLED =
    "$PLACE_HOLDER wasn't called as the feature seems to be disabled for your Instabug " +
            "company account. Please contact support for more information."

internal const val APM_SDK_DISABLED =
    "$PLACE_HOLDER wasn't called. Please make sure to enable APM first by following the " +
            "instructions at this link: https://docs.instabug.com/reference#enable-or-disable-apm"

internal const val FORCE_ABANDONED_FLOW: String =
    "A flow with name $PLACE_HOLDER already started, " +
            "It will be abandoned and a new flow with the same name will be started."

internal const val FLOW_NOT_ENDED_NO_MATCHING_FLOW: String =
    "Can’t end flow, No flow existing with name $PLACE_HOLDER, " +
            "please start the flow by calling startFlow first."
internal const val ATTRIBUTE_NOT_ADDED_NO_MATCHING_FLOW: String =
    "Can’t set flow attribute, No flow existing with name $PLACE_HOLDER, " +
            "please start the flow by calling startFlow first."

internal const val FLOW_NAME_IS_NULL_OR_EMPTY =
    "flow wasn't created. flow name can't be empty or null."

internal const val FLOW_NAME_TRUNCATED =
    "Flow $PLACE_HOLDER was truncated as it was too long. " +
            "Please limit trace names to 150 characters. " +
            "please refer to the docs (https://docs.instabug.com/docs/android-app-flows)"

internal const val ATTRIBUTE_KEY_EXCEEDED_MAX_LENGTH =
    "Flow attribute \"${PLACE_HOLDER}1\" wasn't added to \"${PLACE_HOLDER}2\" as it was too long. " +
            "Please limit attribute key names to 30 characters."

internal const val ATTRIBUTE_KEY_IS_NULL =
    "Flow attribute wasn't added to \"$PLACE_HOLDER\". " +
            "Flow attribute key can't be null or empty string."

internal const val ATTRIBUTE_VALUE_EXCEEDED_MAX_LENGTH =
    "Flow attribute \"${PLACE_HOLDER}1\" wasn't added to \"${PLACE_HOLDER}2\" as it was too long. " +
            "Please limit attribute value names to 60 characters."

internal const val ATTRIBUTE_VALUE_IS_EMPTY =
    "Flow attribute \"${PLACE_HOLDER}1\" wasn't added to \"${PLACE_HOLDER}2\". " +
            "Flow attribute value can't be empty string."


internal const val ATTRIBUTE_EXCEEDED_STORE_LIMIT =
    "Flow attribute \"${PLACE_HOLDER}1\" wasn't added to \"${PLACE_HOLDER}2\". " +
            "Max allowed trace attributes reached. " +
            "Please note that you can add up to ${PLACE_HOLDER}3 attributes to the same flow"

internal const val DROPPED_FLOW_COUNT =
    "Flows dropped count: $PLACE_HOLDER"