package com.instabug.apm.webview.webview_trace.model

import com.instabug.library.map.Mapper

class WebViewTraceModelToCacheModelMapper(
    private val vitalsJsonMapper: Mapper<Map<String, Double>?, String?>
) : Mapper<WebViewTraceModel, WebViewCacheModel?> {

    override fun map(from: WebViewTraceModel): WebViewCacheModel? =
        from.url?.let { url ->
            from.firstEventTimeCapture?.let { startTimeCapture ->
                from.lastEventTimeCapture?.let { lastTimeCapture ->
                    from.isFullScreen?.let { fullScreen ->
                        WebViewCacheModel(
                            url = url,
                            startTimeStampMicro = startTimeCapture.getTimeStampMicro(),
                            durationMicro = lastTimeCapture.getDurationMicroStartingFrom(startTimeCapture),
                            isFulScreen = fullScreen,
                            vitalsJsonObject = vitalsJsonMapper.map(from.vitals)
                        )
                    }
                }
            }
        }
}