package com.instabug.apm.webview.webview_trace.handler

import com.instabug.apm.webview.vital.InstabugWebVitalsEventListener
import com.instabug.apm.webview.webview_trace.WEB_VITALS_CLS
import com.instabug.apm.webview.webview_trace.WEB_VITALS_FID_MICROS
import com.instabug.apm.webview.webview_trace.WEB_VITALS_LCP_MICROS
import com.instabug.apm.webview.webview_trace.model.event.WebViewVitalEvent
import com.instabug.library.factory.ParameterizedFactory
import java.util.concurrent.Executor

class WebViewTraceVitalListener(
    private val webViewTraceId: Long,
    private val repository: WebViewTraceRepository,
    private val executor: Executor
): InstabugWebVitalsEventListener {

    override fun onCls(value: Double) =
        dispatchVitalEvent(WebViewVitalEvent(WEB_VITALS_CLS, value))

    override fun onFid(value: Double) =
        dispatchVitalEvent(
            WebViewVitalEvent(
                WEB_VITALS_FID_MICROS,
                value * 1000
            )
        )

    override fun onLCP(value: Double) =
        dispatchVitalEvent(
            WebViewVitalEvent(
                WEB_VITALS_LCP_MICROS,
                value * 1000
            )
        )

    private  fun dispatchVitalEvent(event: WebViewVitalEvent) =
        executor.execute {
            repository.handleEvent(webViewTraceId, event)
        }
}

class WebViewTraceVitalListenerFactory(
    private val repository: WebViewTraceRepository,
    private val executor: Executor
): ParameterizedFactory<InstabugWebVitalsEventListener,Long> {
    override fun create(type: Long): WebViewTraceVitalListener =
        WebViewTraceVitalListener(type, repository, executor)

}