package com.instabug.apm.uitrace.activitycallbacks

import android.app.Activity
import android.os.Bundle
import androidx.annotation.VisibleForTesting
import com.instabug.apm.model.EventTimeMetricCapture
import java.util.Collections
import java.util.WeakHashMap

class CompositeApmUiTraceActivityCallbacks : APMUiTraceActivityCallbacks {

    @VisibleForTesting
    val callbacks: MutableSet<APMUiTraceActivityCallbacks> =
        Collections.synchronizedSet(
            Collections.newSetFromMap(WeakHashMap())
        )


    fun add(callback: APMUiTraceActivityCallbacks) = callbacks.add(callback)
    fun remove(callback: APMUiTraceActivityCallbacks) =
        callbacks.remove(callback)

    fun clearAll() = callbacks.clear()

    override fun onActivityPreCreated(
        activity: Activity,
        savedInstanceState: Bundle?,
        timeMetric: EventTimeMetricCapture,
        uiTraceId: Long
    ) = handleCallback {
        it.onActivityPreCreated(activity, savedInstanceState, timeMetric, uiTraceId)
    }

    override fun onActivityCreated(
        activity: Activity,
        savedInstanceState: Bundle?,
        timeMetric: EventTimeMetricCapture,
        uiTraceId: Long
    ) = handleCallback {
        it.onActivityCreated(activity, savedInstanceState, timeMetric, uiTraceId)
    }

    override fun onActivityPostCreated(
        activity: Activity,
        savedInstanceState: Bundle?,
        timeMetric: EventTimeMetricCapture
    ) = handleCallback {
        it.onActivityPostCreated(activity, savedInstanceState, timeMetric)
    }

    override fun onActivityPreStarted(activity: Activity, timeMetric: EventTimeMetricCapture) =
        handleCallback {
            it.onActivityPreStarted(activity, timeMetric)
        }

    override fun onActivityStarted(activity: Activity, timeMetric: EventTimeMetricCapture) =
        handleCallback {
            it.onActivityStarted(activity, timeMetric)
        }

    override fun onActivityPostStarted(activity: Activity, timeMetric: EventTimeMetricCapture) =
        handleCallback {
            it.onActivityPostStarted(activity, timeMetric)
        }

    override fun onActivityPreResumed(activity: Activity, timeMetric: EventTimeMetricCapture) =
        handleCallback {
            it.onActivityPreResumed(activity, timeMetric)
        }

    override fun onActivityResumed(
        activity: Activity,
        timeMetric: EventTimeMetricCapture,
        uiTraceId: Long
    ) = handleCallback {
        it.onActivityResumed(activity, timeMetric, uiTraceId)
    }

    override fun onActivityPostResumed(activity: Activity, timeMetric: EventTimeMetricCapture) =
        handleCallback {
            it.onActivityPostResumed(activity, timeMetric)
        }

    override fun onActivityPaused(activity: Activity, timeMetric: EventTimeMetricCapture) =
        handleCallback {
            it.onActivityPaused(activity, timeMetric)
        }

    override fun onActivityStopped(activity: Activity, isAppInBackground: Boolean) =
        handleCallback { it.onActivityStopped(activity, isAppInBackground) }

    override fun onActivitySaveInstanceState(activity: Activity, outState: Bundle) =
        handleCallback {
            it.onActivitySaveInstanceState(activity, outState)
        }

    override fun onActivityDestroyed(activity: Activity) = handleCallback {
        it.onActivityDestroyed(activity)
    }

    private inline fun handleCallback(operation: (APMUiTraceActivityCallbacks) -> Unit) =
        synchronized(callbacks) {
            callbacks.forEach { (operation(it)) }
        }
}