package com.instabug.apm.preferences

import com.instabug.apm.constants.APMConfigurationKeys
import com.instabug.apm.di.ServiceLocator
import com.instabug.library.internal.servicelocator.CoreServiceLocator.getInstabugSharedPreferences
import com.instabug.library.util.nullRetryLazy

val apmPreferences by nullRetryLazy(ServiceLocator::class.java) {
    ServiceLocator.getContext()?.let { ctx ->
        getInstabugSharedPreferences(ctx, APMConfigurationKeys.KEY_APM_SHARED_PREFERENCES);
    }
}