package com.instabug.apm.networkinterception.utils

import com.instabug.apm.constants.ErrorMessages.ERROR_WHILE_INJECTING_EXTERNAL_TRACE_HEADER
import com.instabug.apm.networkinterception.APMNetworkLogWrapper
import com.instabug.library.diagnostics.IBGDiagnostics
import java.net.URLConnection

fun injectExternalNetworkTraceIdHeaderIfPossible(
    connection: URLConnection,
    networkLogWrapper: APMNetworkLogWrapper
) {
    networkLogWrapper.runCatching {
        getInjectableHeader(connection.getRequestProperty("traceparent"))
            ?.forEach { (key, value) -> connection.addRequestProperty(key, value) }
    }.onFailure {
        IBGDiagnostics.reportNonFatal(
            it,
            "UrlConnection $ERROR_WHILE_INJECTING_EXTERNAL_TRACE_HEADER"
        )
    }
}