package com.instabug.apm.networking.mapping.applaunch;

import android.annotation.SuppressLint;

import com.instabug.apm.cache.model.AppLaunchCacheModel;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 Implementation of {@link AppLaunchCacheModel} serialization
 */
@SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
public class AppLaunchMapperImpl implements AppLaunchMapper {

    @Override
    public JSONArray toJsonArray(List<AppLaunchCacheModel> appLaunches) throws JSONException {
        JSONArray tracesArray = new JSONArray();
        for (AppLaunchCacheModel trace : appLaunches) {
            tracesArray.put(toJson(trace));
        }
        return tracesArray;
    }

    @Override
    public JSONObject toJson(AppLaunchCacheModel appLaunch) throws JSONException {
        JSONObject traceJson = new JSONObject();
        traceJson.put(AppLaunchMappingKeys.LAUNCH_TYPE, appLaunch.getType());
        traceJson.put(AppLaunchMappingKeys.LAUNCH_START_TIME, appLaunch.getStartTime());
        traceJson.put(AppLaunchMappingKeys.LAUNCH_DURATION, appLaunch.getDuration());
        traceJson.put(AppLaunchMappingKeys.LAUNCH_SCREEN_NAME, appLaunch.getScreenName());
        Map<String, String> stages = appLaunch.getStages();
        if (stages != null && stages.size() > 0) {
            JSONObject stagesJsonObject = new JSONObject();
            Set<Map.Entry<String, String>> entries = stages.entrySet();
            for (Map.Entry<String, String> entry: entries) {
                String stringValue = entry.getValue();
                String key = entry.getKey();
                try {
                    long longValue = Long.parseLong(stringValue);
                    stagesJsonObject.put(key, longValue);
                } catch (NumberFormatException numberFormatException) {
                    stagesJsonObject.put(key, stringValue);
                }
            }
            traceJson.put(AppLaunchMappingKeys.LAUNCH_STAGES, stagesJsonObject);
        }
        return traceJson;
    }
}
