package com.instabug.apm.networking.mapping.applaunch;

import com.instabug.apm.cache.model.AppLaunchCacheModel;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

/**
 * Serialize {@link AppLaunchCacheModel} to JSON objects / arrays
 */
public interface AppLaunchMapper {

    /**
     * Serialize a list of {@link AppLaunchCacheModel} to a JSON array and return as string
     *
     * @param appLaunches the list of appLaunches to be serialized
     *
     * @throws JSONException if serializing failed.
     */
    JSONArray toJsonArray(List<AppLaunchCacheModel> appLaunches) throws JSONException;

    /**
     * Serialize an object of {@link AppLaunchCacheModel} to a JSON object and return as string
     *
     * @param appLaunch the object of appLaunch to be serialized
     *
     * @throws JSONException if serializing failed.
     */
    JSONObject toJson(AppLaunchCacheModel appLaunch) throws JSONException;
}
