package com.instabug.apm.lifecycle;

import static com.instabug.apm.constants.AppLaunchType.COLD;
import static com.instabug.apm.constants.AppLaunchType.HOT;

import android.annotation.SuppressLint;

import androidx.annotation.Nullable;

import com.instabug.apm.cache.model.AppLaunchCacheModel;
import com.instabug.apm.constants.AppLaunchType;
import com.instabug.apm.model.AppLaunchStage;
import com.instabug.apm.model.AppLaunchStageDetails;

import java.util.HashMap;
import java.util.Map;


public class AppLaunchDataRepository {
    private long activityResumeStartTimeStampMicro;
    private long appLaunchEndMicro;
    private boolean isFirstColdLaunch = true;
    private boolean isHotAppLaunch = true;
    private boolean launchFinished = false;
    private boolean appWasInBG = false;
    private boolean isEndAppLaunchCalledEarly;
    @AppLaunchType
    @Nullable
    private String lastCapturedAppLaunchType = null;
    private final Map<AppLaunchStage, AppLaunchStageDetails> appLaunchStages;
    @Nullable
    private AppLaunchCacheModel appLaunchCacheModel;

    @SuppressLint("ERADICATE_FIELD_NOT_INITIALIZED")
    public AppLaunchDataRepository() {
        appLaunchStages = new HashMap<>();
        AppLaunchStageDetails appCreationStageDetails = new AppLaunchStageDetails();
        appCreationStageDetails.setStageStartTimeStampMicro(System.currentTimeMillis() * 1000);
        appCreationStageDetails.setStageStartTimeMicro(System.nanoTime() / 1000);
        appLaunchStages.put(AppLaunchStage.APP_CREATION, appCreationStageDetails);
    }


    public long getActivityResumeStartTimeStampMicro() {
        return activityResumeStartTimeStampMicro;
    }

    public void setActivityResumeStartTimeStampMicro(long activityResumeStartTimeStampMicro) {
        this.activityResumeStartTimeStampMicro = activityResumeStartTimeStampMicro;
    }

    public long getAppLaunchEndMicro() {
        return appLaunchEndMicro;
    }

    public void setAppLaunchEndMicro(long appLaunchEndMicro) {
        this.appLaunchEndMicro = appLaunchEndMicro;
    }


    public Map<AppLaunchStage, AppLaunchStageDetails> getAppLaunchStages() {
        return appLaunchStages;
    }

    public boolean isHotAppLaunch() {
        return isHotAppLaunch;
    }

    public void setHotAppLaunch(boolean hotAppLaunch) {
        isHotAppLaunch = hotAppLaunch;
    }

    public boolean isFirstColdLaunch() {
        return isFirstColdLaunch;
    }

    public void setFirstColdLaunch(boolean isFirstColdLaunch) {
        this.isFirstColdLaunch = isFirstColdLaunch;
    }

    public boolean isLaunchFinished() {
        return launchFinished;
    }

    public void setLaunchFinished(boolean launchFinished) {
        this.launchFinished = launchFinished;
    }

    public boolean isAppWasInBG() {
        return appWasInBG;
    }

    public void setAppWasInBG(boolean appWasInBG) {
        this.appWasInBG = appWasInBG;
    }

    @Nullable
    @AppLaunchType
    public String getLastCapturedAppLaunchType() {
        return lastCapturedAppLaunchType;
    }

    public void setLastCapturedAppLaunchType(@Nullable @AppLaunchType String lastCapturedAppLaunchType) {
        this.lastCapturedAppLaunchType = lastCapturedAppLaunchType;
    }

    @Nullable
    public AppLaunchCacheModel getAppLaunchCacheModel() {
        return appLaunchCacheModel;
    }

    public void setAppLaunchCacheModel(@Nullable AppLaunchCacheModel appLaunchCacheModel) {
        this.appLaunchCacheModel = appLaunchCacheModel;
    }

    public boolean isEndAppLaunchCalledEarly() {
        return isEndAppLaunchCalledEarly;
    }

    public void setEndAppLaunchCalledEarly(boolean endAppLaunchCalledEarly) {
        isEndAppLaunchCalledEarly = endAppLaunchCalledEarly;
    }

    public long getEndAppLaunchStageDuration() {
        long activityStartEndTimeMicro = 0;
        AppLaunchStageDetails activityStartStage = appLaunchStages.get(AppLaunchStage.ACTIVITY_START);
        if (activityStartStage != null) {
            activityStartEndTimeMicro = activityStartStage.getStageEndTimeMicro();
        }
        return appLaunchEndMicro - activityStartEndTimeMicro;
    }

    @Nullable
    public String getScreenName(@Nullable String launchType) {
        String createdScreenName = null;
        AppLaunchStageDetails activityCreation = appLaunchStages.get(AppLaunchStage.ACTIVITY_CREATION);
        if (activityCreation != null) {
            createdScreenName = activityCreation.getStageScreenName();
        }
        String startedScreenName = null;
        AppLaunchStageDetails activityStart = appLaunchStages.get(AppLaunchStage.ACTIVITY_START);
        if (activityStart != null) {
            startedScreenName = activityStart.getStageScreenName();
        }
        if (launchType == null) {
            return startedScreenName;
        }
        switch (launchType) {
            case COLD:
                if (createdScreenName != null && !createdScreenName.equals(startedScreenName)) {
                    // EndAppLaunch was called during onCreate
                    return createdScreenName;
                }
                return startedScreenName;
            case HOT:
                return startedScreenName;
        }
        return startedScreenName;
    }
}
