package com.instabug.apm.handler.session;

import androidx.annotation.NonNull;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SessionObserverRegistryImpl implements SessionObserverRegistry {

    @NonNull
    private final Set<APMSessionObserver> observers;

    public SessionObserverRegistryImpl() {
        this.observers = Collections.newSetFromMap(new ConcurrentHashMap<APMSessionObserver, Boolean>());
    }

    @Override
    public void register(@NonNull APMSessionObserver observer) {
        observers.add(observer);
    }

    @Override
    public void unregister(@NonNull APMSessionObserver observer) {
        observers.remove(observer);
    }

    @NonNull
    @Override
    public Collection<APMSessionObserver> getObservers() {
        return Collections.unmodifiableCollection(observers);
    }
}
