package com.instabug.apm.handler.applaunch;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.apm.cache.model.AppLaunchCacheModel;
import com.instabug.apm.constants.AppLaunchType;

import java.util.List;

public interface AppLaunchesHandler {

    /**
     * Inserts a new app launch into cache
     *
     * @param sessionID           id of the session which this app launch belongs to
     * @param appLaunchCacheModel app launch model to be cached
     * @return id of the inserted app launch
     */
    long insertAppLaunch(String sessionID, AppLaunchCacheModel appLaunchCacheModel);

    /**
     * Removes all occurrences of a certain type of app launches with its stages and clears stored
     * app launch counts
     *
     * @param type the type of App launches to be removed
     * @param clearCounts true to clear app launch counts, false to leave them untouched
     * @see AppLaunchType
     */
    void removeAppLaunches(@NonNull @AppLaunchType String type, boolean clearCounts);

    /**
     * Removes all app launches occurrences
     */
    void removeAll();

    /**
     * Gets list of cached app launches for passed session id
     *
     * @param sessionID id of the session to get cached app launches for
     * @return List of {@link AppLaunchCacheModel}
     */
    @Nullable
    List<AppLaunchCacheModel> getAppLaunchesForSession(String sessionID);

    /**
     * Update an existing AppLaunch
     *
     * @param currentAppLaunch represents the updated app launch model
     */
    void updateAppLaunch(AppLaunchCacheModel currentAppLaunch);
}
