package com.instabug.apm.di

import java.lang.ref.WeakReference

inline fun <T> getOrCreateSingleton(
    getter: () -> T?,
    setter: (T?) -> Unit,
    factory: () -> T
): T = getter()
    ?: synchronized(ServiceLocator.getServiceLocatorLock()) {
        getter() ?: factory().also { instance ->
            instance?.let { setter(it) }
        }
    }

inline fun <T> getOrCreateSingleInstance(
    getter: () -> WeakReference<T>?,
    setter: (WeakReference<T>?) -> Unit,
    factory: () -> T
): T = getter()?.get()
    ?: synchronized(ServiceLocator.getServiceLocatorLock()) {
        getter()?.get() ?: factory().also { instance ->
            instance?.let { setter(WeakReference(instance)) }
        }
    }