package com.instabug.apm.di

import com.instabug.apm.appflow.di.AppFlowServiceLocator
import com.instabug.apm.compose.compose_spans.ComposeSpansServiceLocator
import com.instabug.apm.networking.mapping.sessions.SessionFeatureJsonFiller

class SessionJSONFillersProvider: Provider<Array<SessionFeatureJsonFiller>> {
    private val fillers: Array<SessionFeatureJsonFiller> by lazy {
        arrayOf(
            ServiceLocator.getUiTracesSessionFeatureJsonFiller(),
            ComposeSpansServiceLocator.sessionFeatureJsonFiller,
            AppFlowServiceLocator.appFlowSessionJsonFiller
        )
    }
    override fun invoke(): Array<SessionFeatureJsonFiller> = fillers

}