package com.instabug.apm.compose.compose_spans.model.transform

import com.instabug.apm.compose.compose_spans.configuration.ComposeSpansConfigurationProvider
import com.instabug.apm.compose.compose_spans.configuration.DEFAULT_COMPOSE_SCREEN_LOADING_SEGMENTATION_BE_ENABLED
import com.instabug.apm.compose.compose_spans.model.ComposeSpansCacheModel
import com.instabug.apm.di.Provider
import com.instabug.library.map.Mapper
import org.json.JSONArray
import org.json.JSONObject

class ComposeSpansListToJsonArrayMapper(
    private val configurationProvider: Provider<ComposeSpansConfigurationProvider?>
) : Mapper<List<ComposeSpansCacheModel>?, JSONArray?> {

    override fun map(from: List<ComposeSpansCacheModel>?): JSONArray? =
        kotlin.runCatching {
            val isScreenLoadingSegmentationEnabled = configurationProvider()
                ?.screenLoadingSegmentationBeEnabled
                ?: DEFAULT_COMPOSE_SCREEN_LOADING_SEGMENTATION_BE_ENABLED
            from?.takeIf { it.isNotEmpty() }
                ?.mapNotNull { it.toJsonObject(isScreenLoadingSegmentationEnabled) }
                ?.let { JSONArray(it) }
        }.getOrNull()

    private fun ComposeSpansCacheModel.toJsonObject(isScreenLoadingSegmentationEnabled: Boolean): JSONObject? =
        takeIf { !spansJsonString.isNullOrEmpty() }
            ?.let { JSONObject() }
            ?.also { jsonObject ->
                jsonObject.put(COMPOSABLE_NAME_KEY, name)
                if (isScreenLoadingSegmentationEnabled) {
                    fillScreenLoadingSegmentationData(jsonObject)
                }
                jsonObject.put(STAGES_KEY, JSONArray(spansJsonString))
            }

    private fun ComposeSpansCacheModel.fillScreenLoadingSegmentationData(jsonObject: JSONObject) =
        jsonObject.takeIf { shouldShowAsScreen }
            ?.apply {
                put(IS_SHOWN_AS_SCREEN, shouldShowAsScreen)
                put(START_TIMESTAMP_KEY, startTimestampMicros)
                put(DURATION_KEY, durationMicros)
            }
}
