package com.instabug.apm.appflow.usecases

import com.instabug.apm.appflow.configuration.AppFlowConfigurationProvider
import com.instabug.apm.appflow.handler.AppFlowHandler
import com.instabug.apm.appflow.model.AppFlowEndReason
import com.instabug.library.core.eventbus.AppStateEvent

class AppFlowForegroundUseCase(
    private val handler: AppFlowHandler,
    private val configurationProvider: AppFlowConfigurationProvider
) : UseCase<Pair<AppStateEvent.ForegroundAppStateEvent, AppStateEvent.BackgroundAppStateEvent?>, Unit> {

    override fun invoke(param: Pair<AppStateEvent.ForegroundAppStateEvent, AppStateEvent.BackgroundAppStateEvent?>) {
        param.takeIf { configurationProvider.enabled }
            ?.also (::sanitizeParamsAndUpdateActiveFlowsEndState)
            ?.also { updateActiveFlowsBackgroundState() }
    }

    private fun sanitizeParamsAndUpdateActiveFlowsEndState(
        params: Pair<AppStateEvent.ForegroundAppStateEvent, AppStateEvent.BackgroundAppStateEvent?>
    ) {
        takeIfBackgroundEventIsNotNull(params)
            ?.let { (currentEvent, previousEvent) ->
                updateActiveFlowsEndState(currentEvent, previousEvent)
            }
    }

    private fun updateActiveFlowsBackgroundState() =
        handler.setActiveFlowsBackgroundFlag(false)

    private fun updateActiveFlowsEndState(
        currentEvent: AppStateEvent.ForegroundAppStateEvent,
        previousEvent: AppStateEvent.BackgroundAppStateEvent
    ) = handler.endActiveFlowsWithReason(
        previousEvent.timeStampMillis,
        currentEvent.timeStampMillis,
        AppFlowEndReason.ABANDONMENT
    )?.takeUnless { it }
        ?.let { handler.setActiveFlowsEndReason(AppFlowEndReason.NONE) }

    private fun takeIfBackgroundEventIsNotNull(param: Pair<AppStateEvent.ForegroundAppStateEvent, AppStateEvent.BackgroundAppStateEvent?>):
            Pair<AppStateEvent.ForegroundAppStateEvent, AppStateEvent.BackgroundAppStateEvent>? =
        param.second?.let { Pair(param.first, it) }

}