package com.instabug.apm.webview.webview_trace.model.event

import com.instabug.apm.model.EventTimeMetricCapture

class WebViewLoadUrlEvent : WebViewEvent, WebViewTraceInitiationEvent {

    override val traceId: Long
    override val shouldInitiateNewTrace = true
    val url: String?

    constructor(
        traceId: Long,
        url: String?,
        timeCapture: EventTimeMetricCapture,
        isTermination: Boolean = false,
        copyCount: Int = 0
    ) : super(
        id = WebViewEventId.LOAD_URL,
        timeCapture = timeCapture,
        isTermination = isTermination,
        copyCount = copyCount,
    ) {
        this.traceId = traceId
        this.url = url
    }

    constructor(from: WebViewLoadUrlEvent, isTerminationOverride: Boolean?) :
            super(from, isTerminationOverride) {
        this.traceId = from.traceId
        this.url = from.url
    }

    override fun copy(isTerminationOverride: Boolean?): WebViewLoadUrlEvent =
        WebViewLoadUrlEvent(this, isTerminationOverride)

}