package com.instabug.apm.webview.webview_trace.flow

import com.instabug.apm.webview.webview_trace.model.event.WebViewEvent

/**
 * Composite WebViewEventFlow that delegates to multiple WebViewEventFlow instances
 */
class WebViewCompositeFlow(private var flows: List<WebViewEventFlow>): WebViewEventFlow {

    override fun process(event: WebViewEvent): Boolean {
        var process = true
        for (index in flows.indices) {
            process = flows[index].process(event)
            if (!process) {
                break
            }
        }
        return process
    }

    override fun finished(): Boolean = flows.any { it.finished() }

    override fun getPendingEvent(): WebViewEvent? =
        flows.firstOrNull { it.getPendingEvent() != null }?.getPendingEvent()
}