package com.instabug.apm.webview.dispatch.util;

import android.webkit.WebView;
import android.webkit.WebViewClient;

import androidx.annotation.NonNull;

import com.instabug.library.transform.TransformationClass;

import java.util.Map;

@TransformationClass
public class WebViewDelegator {

    private WebViewDelegator() {
    }

    public static void setWebViewClient(@NonNull WebView webView, WebViewClient webViewClient) {
        webView.setWebViewClient(webViewClient);
    }

    public static void loadUrl(@NonNull WebView webView, String url) {
        webView.loadUrl(url);
    }

    public static void loadUrl(
            @NonNull WebView webView,
            String url,
            Map<String, String> additionalHttpHeaders
    ) {
        webView.loadUrl(url, additionalHttpHeaders);
    }

    public static void postUrl(@NonNull WebView webView, String url, byte[] postData) {
        webView.postUrl(url, postData);
    }

    public static void loadData(
            @NonNull WebView webView,
            String data,
            String mimeType,
            String encoding
    ) {
        webView.loadData(data, mimeType, encoding);
    }

    public static void loadDataWithBaseURL(
            WebView webView,
            String baseUrl,
            String data,
            String mimeType,
            String encoding,
            String historyUrl
    ) {
        webView.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
    }
}
