package com.instabug.apm.model

/**
 * A model that binds EventTimeMetricCapture to other models
 */
class TimeCaptureBoundModel<T> @JvmOverloads constructor(
    val model: T, val timeCapture: EventTimeMetricCapture = EventTimeMetricCapture()
)

fun <T> T?.bindTimeCapture(
    timeCapture: EventTimeMetricCapture = EventTimeMetricCapture()
) = TimeCaptureBoundModel(this, timeCapture)

fun <T> TimeCaptureBoundModel<T?>.takeIfModelNotNull(): TimeCaptureBoundModel<T>? =
    model?.let { TimeCaptureBoundModel(it, timeCapture) }