package com.instabug.apm.model

import java.util.concurrent.TimeUnit

open class EventTimeMetricCapture {
    private val nanoTime: Long
    private val timeStampMillis: Long

    init {
        nanoTime = System.nanoTime()
        timeStampMillis = System.currentTimeMillis()
    }

    open fun getNanoTime() = nanoTime
    open fun getMicroTime() = nanoTime / 1000
    open fun getTimeStampMillis() = timeStampMillis
    open fun getTimeStampMicro() = timeStampMillis * 1000

    fun getDurationMillisStartingFrom(other: EventTimeMetricCapture) =
        TimeUnit.NANOSECONDS.toMillis(getDurationNanoFrom(other))

    fun getDurationMicroStartingFrom(other: EventTimeMetricCapture) =
        TimeUnit.NANOSECONDS.toMicros(getDurationNanoFrom(other))
    fun getDurationNanoFrom(other: EventTimeMetricCapture) = nanoTime - other.nanoTime

}