package com.instabug.apm.configuration.cp

import androidx.annotation.StringDef

@StringDef(
    APMFeature.SCREEN_LOADING,
    APMFeature.NETWORK_INTERCEPTION_ENABLED,
    APMFeature.CP_NATIVE_INTERCEPTION_ENABLED,
    APMFeature.APM_NETWORK_PLUGIN_INSTALLED
)
@Retention(AnnotationRetention.SOURCE)
annotation class APMFeature {
    companion object {
        const val SCREEN_LOADING = "screen_loading"
        const val NETWORK_INTERCEPTION_ENABLED = "network_interception_enabled"
        const val CP_NATIVE_INTERCEPTION_ENABLED = "cp_native_interception_enabled"
        const val APM_NETWORK_PLUGIN_INSTALLED = "network_plugin_installed"
    }
}
