package com.instabug.apm.compose.compose_spans

import com.instabug.apm.compose.ComposeEventListener
import com.instabug.apm.compose.compose_spans.model.ComposeSpanEvent
import com.instabug.apm.model.EventTimeMetricCapture

class ComposeSpansEventListener(
    private val repository: ComposeSpansEventsRepository
) : ComposeEventListener {

    override fun onCompositionStarted(
        id: Int,
        screenName: String,
        timeMetricCapture: EventTimeMetricCapture,
        showAsScreen: Boolean
    ) {
        repository.addEvent(
            ComposeSpanEvent.CompositionStarted(
                id,
                screenName,
                timeMetricCapture,
                showAsScreen
            )
        )
    }

    override fun onCompositionEnded(
        id: Int,
        screenName: String,
        timeMetricCapture: EventTimeMetricCapture
    ) {
        repository.addEvent(
            ComposeSpanEvent.CompositionEnded(
                id,
                screenName,
                timeMetricCapture
            )
        )
    }

    override fun onMeasuringAndLayoutStarted(
        id: Int,
        screenName: String,
        timeMetricCapture: EventTimeMetricCapture
    ) {
        repository.addEvent(
            ComposeSpanEvent.MeasuringAndLayoutStarted(
                id,
                screenName,
                timeMetricCapture
            )
        )
    }

    override fun onMeasuringAndLayoutEnded(
        id: Int,
        screenName: String,
        timeMetricCapture: EventTimeMetricCapture
    ) {
        repository.addEvent(
            ComposeSpanEvent.MeasuringAndLayoutEnded(
                id,
                screenName,
                timeMetricCapture
            )
        )
    }

    override fun onRenderingStarted(
        id: Int,
        screenName: String,
        timeMetricCapture: EventTimeMetricCapture
    ) {
        repository.addEvent(
            ComposeSpanEvent.RenderingStarted(
                id,
                screenName,
                timeMetricCapture
            )
        )
    }

    override fun onRenderingEnded(
        id: Int,
        screenName: String,
        timeMetricCapture: EventTimeMetricCapture
    ) {
        repository.addEvent(
            ComposeSpanEvent.RenderingEnded(
                id,
                screenName,
                timeMetricCapture
            )
        )
    }

    override fun onDispose(
        id: Int,
        screenName: String,
        timeMetricCapture: EventTimeMetricCapture
    ) {
        repository.addEvent(
            ComposeSpanEvent.Dispose(
                id,
                screenName,
                timeMetricCapture
            )
        )
    }
}