/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.webview.webview_trace.flow;

import com.instabug.apm.webview.webview_trace.configuration.WebViewTraceConfigurationProvider;
import com.instabug.apm.webview.webview_trace.flow.WebViewEventFlow;
import com.instabug.apm.webview.webview_trace.model.event.WebViewEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\bH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/instabug/apm/webview/webview_trace/flow/WebViewTimeThresholdFlow;", "Lcom/instabug/apm/webview/webview_trace/flow/WebViewEventFlow;", "configurations", "Lcom/instabug/apm/webview/webview_trace/configuration/WebViewTraceConfigurationProvider;", "(Lcom/instabug/apm/webview/webview_trace/configuration/WebViewTraceConfigurationProvider;)V", "lastEvent", "Lcom/instabug/apm/webview/webview_trace/model/event/WebViewEvent;", "maxEventThresholdReached", "", "finished", "getPendingEvent", "process", "event", "instabug-apm_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nWebViewTimeThresholdFlow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebViewTimeThresholdFlow.kt\ncom/instabug/apm/webview/webview_trace/flow/WebViewTimeThresholdFlow\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n1#2:37\n*E\n"})
public final class WebViewTimeThresholdFlow
implements WebViewEventFlow {
    @NotNull
    private final WebViewTraceConfigurationProvider configurations;
    @Nullable
    private WebViewEvent lastEvent;
    private boolean maxEventThresholdReached;

    public WebViewTimeThresholdFlow(@NotNull WebViewTraceConfigurationProvider webViewTraceConfigurationProvider) {
        Intrinsics.checkNotNullParameter((Object)webViewTraceConfigurationProvider, (String)"configurations");
        this.configurations = webViewTraceConfigurationProvider;
    }

    @Override
    public boolean process(@NotNull WebViewEvent webViewEvent) {
        boolean bl;
        WebViewEvent webViewEvent2 = webViewEvent;
        Intrinsics.checkNotNullParameter((Object)webViewEvent2, (String)"event");
        WebViewEvent webViewEvent3 = webViewEvent2.isTimeBased() ? webViewEvent : null;
        if (webViewEvent3 != null) {
            webViewEvent3 = this.lastEvent;
            if (webViewEvent3 != null) {
                this.lastEvent = webViewEvent;
                boolean bl2 = webViewEvent.getTimeCapture().getDurationMillisStartingFrom(webViewEvent3.getTimeCapture()) > (long)this.configurations.getMaxCallbackThresholdMs();
                this.maxEventThresholdReached = bl2;
                bl = bl2 ^ true;
            } else {
                this.lastEvent = webViewEvent;
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean finished() {
        return this.maxEventThresholdReached;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public WebViewEvent getPendingEvent() {
        WebViewEvent webViewEvent = this.lastEvent;
        if (webViewEvent == null) return null;
        if (!this.finished()) return null;
        if (webViewEvent == null) return null;
        WebViewEvent webViewEvent2 = webViewEvent.copy(Boolean.TRUE);
        return webViewEvent2;
    }
}

