/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.webview.webview_trace.configuration;

import com.instabug.apm.configuration.ConfigurationHandler;
import com.instabug.apm.logger.APMLogger;
import com.instabug.apm.webview.webview_trace.configuration.WebViewTraceConfigurationProvider;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.extenstions.GenericExtKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u0006H\u0002J\f\u0010\u000b\u001a\u00020\u0006*\u00020\bH\u0002J\f\u0010\f\u001a\u00020\u0006*\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/instabug/apm/webview/webview_trace/configuration/WebViewTraceConfigurationHandler;", "Lcom/instabug/apm/configuration/ConfigurationHandler;", "configurationProvider", "Lcom/instabug/apm/webview/webview_trace/configuration/WebViewTraceConfigurationProvider;", "(Lcom/instabug/apm/webview/webview_trace/configuration/WebViewTraceConfigurationProvider;)V", "handleConfigurations", "", "configsJson", "Lorg/json/JSONObject;", "reset", "resetAndLogNotParsed", "cacheWebViewConfigs", "parseWebViewConfigs", "instabug-apm_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nWebViewTraceConfigurationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebViewTraceConfigurationHandler.kt\ncom/instabug/apm/webview/webview_trace/configuration/WebViewTraceConfigurationHandler\n+ 2 GenericExt.kt\ncom/instabug/library/util/extenstions/GenericExtKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n7#2,6:46\n13#2,5:53\n1#3:52\n*S KotlinDebug\n*F\n+ 1 WebViewTraceConfigurationHandler.kt\ncom/instabug/apm/webview/webview_trace/configuration/WebViewTraceConfigurationHandler\n*L\n15#1:46,6\n15#1:53,5\n15#1:52\n*E\n"})
public final class WebViewTraceConfigurationHandler
implements ConfigurationHandler {
    @NotNull
    private final WebViewTraceConfigurationProvider configurationProvider;

    public WebViewTraceConfigurationHandler(@NotNull WebViewTraceConfigurationProvider webViewTraceConfigurationProvider) {
        Intrinsics.checkNotNullParameter((Object)webViewTraceConfigurationProvider, (String)"configurationProvider");
        this.configurationProvider = webViewTraceConfigurationProvider;
    }

    private final void parseWebViewConfigs(JSONObject jSONObject) {
        boolean bl = jSONObject.optBoolean("enabled", false);
        this.configurationProvider.setFeatureEnabled(bl);
        if (bl) {
            this.cacheWebViewConfigs(jSONObject);
        } else {
            this.reset();
        }
    }

    private final void cacheWebViewConfigs(JSONObject jSONObject) {
        WebViewTraceConfigurationProvider webViewTraceConfigurationProvider = ((WebViewTraceConfigurationHandler)((Object)webViewTraceConfigurationProvider)).configurationProvider;
        webViewTraceConfigurationProvider.setRequestLimit(jSONObject.optInt("limit_per_request", 200));
        webViewTraceConfigurationProvider.setStoreLimit(jSONObject.optInt("store_limit", 1000));
        webViewTraceConfigurationProvider.setMaxCallbackThresholdMs(jSONObject.optInt("max_callback_threshold_ms", 2000));
        webViewTraceConfigurationProvider.setPartialViewEnabled(jSONObject.optBoolean("partial_enabled", false));
        webViewTraceConfigurationProvider.setPartialViewPercentage((float)jSONObject.optDouble("partial_percentage", 0.75));
    }

    private final void resetAndLogNotParsed() {
        APMLogger.logSDKProtected("Can't parse WebViews configurations, object is null.");
        this.reset();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleConfigurations(@Nullable JSONObject jSONObject) {
        if (jSONObject != null && (jSONObject = jSONObject.optJSONObject("ui")) != null && (jSONObject = jSONObject.optJSONObject("webviews")) != null) {
            Object object;
            Object object2;
            block5: {
                WebViewTraceConfigurationHandler webViewTraceConfigurationHandler = object2;
                JSONObject jSONObject2 = jSONObject;
                object2 = "IBG-Core";
                jSONObject = null;
                try {
                    // empty try
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    break block5;
                }
                {
                    webViewTraceConfigurationHandler.parseWebViewConfigs(jSONObject2);
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Object object3 = object2;
                object2 = GenericExtKt.constructErrorMessage((String)jSONObject, (Throwable)throwable);
                InstabugCore.reportError((Throwable)throwable, (String)object2);
                InstabugSDKLogger.e((String)object3, (String)object2, (Throwable)throwable);
            }
            Result.box-impl((Object)object);
            return;
        }
        ((WebViewTraceConfigurationHandler)object2).resetAndLogNotParsed();
    }

    @Override
    public void reset() {
        this.configurationProvider.reset();
    }
}

