/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.webview.vital;

import android.annotation.SuppressLint;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import androidx.annotation.MainThread;
import com.instabug.apm.webview.vital.InstabugWebVitalsEventListener;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.util.DeviceStateProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\rH\u0017\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\rH\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\rH\u0017\u00a2\u0006\u0004\b\u0012\u0010\u0010J\u0017\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0013H\u0017\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0018\u0010\t\u001a\u0004\u0018\u00010\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lcom/instabug/apm/webview/vital/InstabugWebViewVitalJSInterface;", "Lcom/instabug/apm/webview/vital/InstabugWebVitalsEventListener;", "<init>", "()V", "Landroid/webkit/WebView;", "webView", "", "attach", "(Landroid/webkit/WebView;)Z", "listener", "", "listenToWebVitals", "(Landroid/webkit/WebView;Lcom/instabug/apm/webview/vital/InstabugWebVitalsEventListener;)V", "", "value", "onCls", "(D)V", "onFid", "onLCP", "", "message", "onError", "(Ljava/lang/String;)V", "Lcom/instabug/apm/webview/vital/InstabugWebVitalsEventListener;", "Companion", "instabug-apm_defaultUiRelease"}, xi=48)
public final class InstabugWebViewVitalJSInterface
implements InstabugWebVitalsEventListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String vitalsScript = "(function() {\n\n  var script = document.createElement('script');\n  // pinned to version 4.0.0 for stability \n  script.src = 'https://unpkg.com/web-vitals@4.0.0/dist/web-vitals.iife.js';\n\n  script.onload = function() {\n    // IMPORTANT: Check *again* after our script loads, in case it overwrote or failed.\n    if (window.webVitals) { // Does the webVitals object exist?\n\n      // Check specifically for each function before calling it\n      if (typeof window.webVitals.onCLS === 'function') {\n        window.webVitals.onCLS(function(vital) { IBGVitals.onCls(vital.value); }, { reportAllChanges: true });\n      } else {\n        IBGVitals.onError('IBGVitals: webVitals.onCLS is not a function after script load.');\n      }\n\n      if (typeof window.webVitals.onFID === 'function') {\n        window.webVitals.onFID(function(vital) { IBGVitals.onFid(vital.value); }, { reportAllChanges: true });\n      } else {\n        IBGVitals.onError('IBGVitals: webVitals.onFID is not a function after script load.'); // Log the specific error\n      }\n\n      if (typeof window.webVitals.onLCP === 'function') {\n        window.webVitals.onLCP(function(vital) { IBGVitals.onLCP(vital.value); }, { reportAllChanges: true });\n      } else {\n        IBGVitals.onError('IBGVitals: webVitals.onLCP is not a function after script load.');\n      }\n\n    } else {\n      IBGVitals.onError('IBGVitals: window.webVitals object not found after script load.');\n    }\n  };\n\n  script.onerror = function() {\n     // Handle case where the script *itself* fails to load (network error, etc)\n     IBGVitals.onError('IBGVitals: Failed to load web-vitals script from unpkg.');\n     \n  };\n\n  document.head.appendChild(script);\n})();";
    @Nullable
    private InstabugWebVitalsEventListener listener;

    @MainThread
    @SuppressLint(value={"NewApi"})
    public final boolean attach(@NotNull WebView webView) {
        WebView webView2 = webView;
        Intrinsics.checkNotNullParameter((Object)webView2, (String)"webView");
        if (webView2.getSettings().getJavaScriptEnabled() && DeviceStateProvider.getOSVersion() >= 26) {
            webView.addJavascriptInterface((Object)this, "IBGVitals");
            return true;
        }
        return false;
    }

    @MainThread
    @SuppressLint(value={"NewApi"})
    public final void listenToWebVitals(@NotNull WebView webView, @NotNull InstabugWebVitalsEventListener instabugWebVitalsEventListener) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        Intrinsics.checkNotNullParameter((Object)instabugWebVitalsEventListener, (String)"listener");
        if (webView.getSettings().getJavaScriptEnabled() && DeviceStateProvider.getOSVersion() >= 26) {
            this.listener = instabugWebVitalsEventListener;
            webView.evaluateJavascript(vitalsScript, null);
        }
    }

    @Override
    @JavascriptInterface
    public void onCls(double d) {
        InstabugWebVitalsEventListener instabugWebVitalsEventListener = ((InstabugWebViewVitalJSInterface)instabugWebVitalsEventListener).listener;
        if (instabugWebVitalsEventListener != null) {
            instabugWebVitalsEventListener.onCls(d);
        }
    }

    @Override
    @JavascriptInterface
    public void onFid(double d) {
        InstabugWebVitalsEventListener instabugWebVitalsEventListener = ((InstabugWebViewVitalJSInterface)instabugWebVitalsEventListener).listener;
        if (instabugWebVitalsEventListener != null) {
            instabugWebVitalsEventListener.onFid(d);
        }
    }

    @Override
    @JavascriptInterface
    public void onLCP(double d) {
        InstabugWebVitalsEventListener instabugWebVitalsEventListener = ((InstabugWebViewVitalJSInterface)instabugWebVitalsEventListener).listener;
        if (instabugWebVitalsEventListener != null) {
            instabugWebVitalsEventListener.onLCP(d);
        }
    }

    @JavascriptInterface
    public void onError(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"message");
        IBGDiagnostics.reportNonFatalAndLog((Throwable)new Exception(string), (String)string, (String)"IBG-APM");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/instabug/apm/webview/vital/InstabugWebViewVitalJSInterface$Companion;", "", "()V", "jsInterfaceName", "", "vitalsScript", "instabug-apm_defaultUiRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

