/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.uitrace.uihangs;

import android.view.Choreographer;
import androidx.annotation.RequiresApi;
import com.instabug.apm.cache.model.UiHangModel;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.uitrace.uihangs.APMChoreographer;
import com.instabug.apm.uitrace.uihangs.FrameDropsCalculator;
import com.instabug.apm.uitrace.uihangs.UiHangHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001d\u001a\u00020\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u0018H\u0016J\b\u0010\u001f\u001a\u00020\u0018H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/instabug/apm/uitrace/uihangs/UiHangHandlerImpl;", "Lcom/instabug/apm/uitrace/uihangs/UiHangHandler;", "Landroid/view/Choreographer$FrameCallback;", "configurationProvider", "Lcom/instabug/apm/configuration/APMConfigurationProvider;", "choreographer", "Lcom/instabug/apm/uitrace/uihangs/APMChoreographer;", "frameDropsCalculator", "Lcom/instabug/apm/uitrace/uihangs/FrameDropsCalculator;", "(Lcom/instabug/apm/configuration/APMConfigurationProvider;Lcom/instabug/apm/uitrace/uihangs/APMChoreographer;Lcom/instabug/apm/uitrace/uihangs/FrameDropsCalculator;)V", "_uiHangModel", "Lcom/instabug/apm/cache/model/UiHangModel;", "canStart", "", "getCanStart", "()Z", "isRegistered", "uiHangModel", "getUiHangModel", "()Lcom/instabug/apm/cache/model/UiHangModel;", "uiTracesLargeDropThreshold", "", "uiTracesSmallDropThreshold", "clearUiHangModel", "", "doFrame", "frameTimeNanos", "", "incrementLargeDropDurationIfPossible", "frameRenderingDurationMicros", "start", "stop", "instabug-apm_defaultUiRelease"})
@RequiresApi(value=16)
@SourceDebugExtension(value={"SMAP\nUiHangHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiHangHandler.kt\ncom/instabug/apm/uitrace/uihangs/UiHangHandlerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class UiHangHandlerImpl
implements UiHangHandler,
Choreographer.FrameCallback {
    @NotNull
    private final APMConfigurationProvider configurationProvider;
    @NotNull
    private final APMChoreographer choreographer;
    @NotNull
    private final FrameDropsCalculator frameDropsCalculator;
    @Nullable
    private UiHangModel _uiHangModel;
    private boolean isRegistered;
    private float uiTracesLargeDropThreshold;
    private float uiTracesSmallDropThreshold;

    public UiHangHandlerImpl(@NotNull APMConfigurationProvider aPMConfigurationProvider, @NotNull APMChoreographer aPMChoreographer, @NotNull FrameDropsCalculator frameDropsCalculator) {
        Intrinsics.checkNotNullParameter((Object)aPMConfigurationProvider, (String)"configurationProvider");
        Intrinsics.checkNotNullParameter((Object)aPMChoreographer, (String)"choreographer");
        Intrinsics.checkNotNullParameter((Object)frameDropsCalculator, (String)"frameDropsCalculator");
        this.configurationProvider = aPMConfigurationProvider;
        this.choreographer = aPMChoreographer;
        this.frameDropsCalculator = frameDropsCalculator;
        this.uiTracesLargeDropThreshold = Float.MAX_VALUE;
        this.uiTracesSmallDropThreshold = Float.MAX_VALUE;
    }

    private final boolean getCanStart() {
        return !this.isRegistered && this.configurationProvider.isAutoUiHangsEnabled();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final UiHangModel incrementLargeDropDurationIfPossible(long l) {
        UiHangModel uiHangModel = this._uiHangModel;
        if (uiHangModel == null) return null;
        if (!((float)l > this.uiTracesLargeDropThreshold)) return null;
        if (uiHangModel == null) return null;
        uiHangModel.incrementLargeDropsDuration(l);
        return uiHangModel;
    }

    @Override
    @Nullable
    public UiHangModel getUiHangModel() {
        return this._uiHangModel;
    }

    @Override
    public void start() {
        if (this.getCanStart()) {
            UiHangHandlerImpl uiHangHandlerImpl = this;
            uiHangHandlerImpl.uiTracesLargeDropThreshold = uiHangHandlerImpl.configurationProvider.getUiTraceLargeDropThreshold();
            uiHangHandlerImpl.uiTracesSmallDropThreshold = uiHangHandlerImpl.configurationProvider.getUiTraceSmallDropThreshold();
            uiHangHandlerImpl.isRegistered = true;
            uiHangHandlerImpl.frameDropsCalculator.reset();
            uiHangHandlerImpl._uiHangModel = new UiHangModel();
            uiHangHandlerImpl.choreographer.addCallback(this);
        }
    }

    @Override
    public void stop() {
        if (this.isRegistered) {
            this.isRegistered = false;
            this.choreographer.removeCallback(this);
        }
    }

    @Override
    public void clearUiHangModel() {
        this._uiHangModel = null;
    }

    public void doFrame(long l) {
        Long l2 = this.frameDropsCalculator.calculateFrameDuration(l, this.uiTracesSmallDropThreshold);
        if (l2 != null) {
            long l3 = l2;
            UiHangModel uiHangModel = this._uiHangModel;
            if (uiHangModel != null) {
                uiHangModel.incrementSmallDropsDuration(l3);
            }
            this.incrementLargeDropDurationIfPossible(l3);
        }
    }
}

