/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.uitrace.manager;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.RequiresApi;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.di.Provider;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.model.EventTimeMetricCapture;
import com.instabug.apm.uitrace.activitycallbacks.APMUiTraceActivityCallbacks;
import com.instabug.apm.uitrace.activitycallbacks.CompositeApmUiTraceActivityCallbacks;
import com.instabug.apm.uitrace.handler.CPAutomaticUiTracesHandlerImpl;
import com.instabug.apm.uitrace.manager.UiTracesManager;
import com.instabug.apm.uitrace.repo.UiTracesRepo;
import com.instabug.apm.uitrace.util.UiTraceUtilsKt;
import com.instabug.apm.util.ExceptionUtilKt;
import com.instabug.apm.util.device.APMDeviceStateProvider;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0007\u0018\u00002\u00020\u0001B\u0081\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0005\u00a2\u0006\u0002\u0010\u001aJ\u000f\u0010\"\u001a\u0004\u0018\u00010#H\u0002\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020#H\u0016J\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020#H\u0002J\n\u0010)\u001a\u0004\u0018\u00010\u0006H\u0002J\"\u0010*\u001a\u00020#2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020'H\u0016J\"\u0010/\u001a\u00020#2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020'H\u0016J\b\u00100\u001a\u00020#H\u0016J\b\u00101\u001a\u00020#H\u0002J\b\u00102\u001a\u00020#H\u0002J\b\u00103\u001a\u00020#H\u0016J\b\u00104\u001a\u00020#H\u0002J\b\u00105\u001a\u00020#H\u0016J\b\u00106\u001a\u00020#H\u0002J\b\u00107\u001a\u00020#H\u0002J\b\u00108\u001a\u00020#H\u0002J\f\u00103\u001a\u00020\u0006*\u00020\u0006H\u0002J\f\u00109\u001a\u00020\u0006*\u00020\u0006H\u0002R\u0014\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/instabug/apm/uitrace/manager/UiTracesManagerImpl;", "Lcom/instabug/apm/uitrace/manager/UiTracesManager;", "compositeApmUiTraceActivityCallbacks", "Lcom/instabug/apm/uitrace/activitycallbacks/CompositeApmUiTraceActivityCallbacks;", "nativeAutomaticUiTraceHandlerProvider", "Lcom/instabug/apm/di/Provider;", "Lcom/instabug/apm/uitrace/activitycallbacks/APMUiTraceActivityCallbacks;", "cpAutomaticUiTraceHandlerProvider", "Lcom/instabug/apm/uitrace/handler/CPAutomaticUiTracesHandlerImpl;", "customUiTracesHandlerActivityCallbacksProvider", "configurationProvider", "Lcom/instabug/apm/configuration/APMConfigurationProvider;", "executor", "Ljava/util/concurrent/Executor;", "repo", "Lcom/instabug/apm/uitrace/repo/UiTracesRepo;", "internalTrackingDelegate", "Lcom/instabug/library/tracking/InstabugInternalTrackingDelegate;", "deviceStateProvider", "Lcom/instabug/apm/util/device/APMDeviceStateProvider;", "settingsManager", "Lcom/instabug/library/settings/SettingsManager;", "logger", "Lcom/instabug/apm/logger/internal/Logger;", "contextProvider", "Landroid/content/Context;", "(Lcom/instabug/apm/uitrace/activitycallbacks/CompositeApmUiTraceActivityCallbacks;Lcom/instabug/apm/di/Provider;Lcom/instabug/apm/di/Provider;Lcom/instabug/apm/di/Provider;Lcom/instabug/apm/configuration/APMConfigurationProvider;Ljava/util/concurrent/Executor;Lcom/instabug/apm/uitrace/repo/UiTracesRepo;Lcom/instabug/library/tracking/InstabugInternalTrackingDelegate;Lcom/instabug/apm/util/device/APMDeviceStateProvider;Lcom/instabug/library/settings/SettingsManager;Lcom/instabug/apm/logger/internal/Logger;Lcom/instabug/apm/di/Provider;)V", "canCaptureCustomUiTraces", "", "getCanCaptureCustomUiTraces", "()Z", "cpAutomaticUiTraceHandler", "isNativeApp", "nativeAutomaticUiTraceHandler", "clearUiHangsIfNotEnabled", "", "()Lkotlin/Unit;", "endAll", "getEndTimeInMicros", "", "onAutomaticUiTracesStateChanged", "onCustomUiTraceStateChanged", "onScreenChanged", "screenName", "", "timeStampMicro", "uiTraceId", "onScreenChangedSync", "onStateChanged", "registerCPAutomaticUiTraceHandler", "registerNativeAutomaticUiTraceHandler", "start", "startAutomaticUiTraces", "startSynchronous", "stopAutomaticUiTraces", "unregisterCPAutomaticUiTraceHandler", "unregisterNativeAutomaticUiTraceHandler", "stop", "instabug-apm_defaultUiRelease"})
@RequiresApi(value=16)
@SourceDebugExtension(value={"SMAP\nUiTracesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiTracesManager.kt\ncom/instabug/apm/uitrace/manager/UiTracesManagerImpl\n+ 2 ExceptionUtil.kt\ncom/instabug/apm/util/ExceptionUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n7#2:209\n8#2:211\n7#2:213\n8#2:215\n7#2:216\n8#2:219\n1#3:210\n1#3:212\n1#3:214\n1#3:217\n1#3:218\n*S KotlinDebug\n*F\n+ 1 UiTracesManager.kt\ncom/instabug/apm/uitrace/manager/UiTracesManagerImpl\n*L\n93#1:209\n93#1:211\n100#1:213\n100#1:215\n109#1:216\n109#1:219\n93#1:210\n100#1:214\n109#1:217\n*E\n"})
public final class UiTracesManagerImpl
implements UiTracesManager {
    @NotNull
    private final CompositeApmUiTraceActivityCallbacks compositeApmUiTraceActivityCallbacks;
    @NotNull
    private final Provider<APMUiTraceActivityCallbacks> nativeAutomaticUiTraceHandlerProvider;
    @NotNull
    private final Provider<CPAutomaticUiTracesHandlerImpl> cpAutomaticUiTraceHandlerProvider;
    @NotNull
    private final Provider<APMUiTraceActivityCallbacks> customUiTracesHandlerActivityCallbacksProvider;
    @NotNull
    private final APMConfigurationProvider configurationProvider;
    @NotNull
    private final Executor executor;
    @NotNull
    private final UiTracesRepo repo;
    @NotNull
    private final InstabugInternalTrackingDelegate internalTrackingDelegate;
    @NotNull
    private final APMDeviceStateProvider deviceStateProvider;
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Provider<Context> contextProvider;
    @Nullable
    private APMUiTraceActivityCallbacks nativeAutomaticUiTraceHandler;
    @Nullable
    private CPAutomaticUiTracesHandlerImpl cpAutomaticUiTraceHandler;

    public UiTracesManagerImpl(@NotNull CompositeApmUiTraceActivityCallbacks compositeApmUiTraceActivityCallbacks, @NotNull Provider<APMUiTraceActivityCallbacks> provider, @NotNull Provider<CPAutomaticUiTracesHandlerImpl> provider2, @NotNull Provider<APMUiTraceActivityCallbacks> provider3, @NotNull APMConfigurationProvider aPMConfigurationProvider, @NotNull Executor executor2, @NotNull UiTracesRepo uiTracesRepo, @NotNull InstabugInternalTrackingDelegate instabugInternalTrackingDelegate, @NotNull APMDeviceStateProvider aPMDeviceStateProvider, @NotNull SettingsManager settingsManager, @NotNull Logger logger2, @NotNull Provider<Context> provider4) {
        Intrinsics.checkNotNullParameter((Object)compositeApmUiTraceActivityCallbacks, (String)"compositeApmUiTraceActivityCallbacks");
        Intrinsics.checkNotNullParameter(provider, (String)"nativeAutomaticUiTraceHandlerProvider");
        Intrinsics.checkNotNullParameter(provider2, (String)"cpAutomaticUiTraceHandlerProvider");
        Intrinsics.checkNotNullParameter(provider3, (String)"customUiTracesHandlerActivityCallbacksProvider");
        Intrinsics.checkNotNullParameter((Object)aPMConfigurationProvider, (String)"configurationProvider");
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)uiTracesRepo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)instabugInternalTrackingDelegate, (String)"internalTrackingDelegate");
        Intrinsics.checkNotNullParameter((Object)aPMDeviceStateProvider, (String)"deviceStateProvider");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter(provider4, (String)"contextProvider");
        this.compositeApmUiTraceActivityCallbacks = compositeApmUiTraceActivityCallbacks;
        this.nativeAutomaticUiTraceHandlerProvider = provider;
        this.cpAutomaticUiTraceHandlerProvider = provider2;
        this.customUiTracesHandlerActivityCallbacksProvider = provider3;
        this.configurationProvider = aPMConfigurationProvider;
        this.executor = executor2;
        this.repo = uiTracesRepo;
        this.internalTrackingDelegate = instabugInternalTrackingDelegate;
        this.deviceStateProvider = aPMDeviceStateProvider;
        this.settingsManager = settingsManager;
        this.logger = logger2;
        this.contextProvider = provider4;
    }

    private final boolean isNativeApp() {
        return this.settingsManager.getEarlyCurrentPlatform(this.contextProvider.invoke()) == 2;
    }

    private final boolean getCanCaptureCustomUiTraces() {
        return this.isNativeApp() && this.configurationProvider.isUiHangsFeatureEnabled();
    }

    private final void onAutomaticUiTracesStateChanged() {
        if (this.configurationProvider.isUiTraceEnabled()) {
            UiTracesManagerImpl uiTracesManagerImpl = this;
            uiTracesManagerImpl.startAutomaticUiTraces();
            uiTracesManagerImpl.clearUiHangsIfNotEnabled();
        } else {
            this.stopAutomaticUiTraces();
        }
    }

    private final void startAutomaticUiTraces() {
        if (this.isNativeApp()) {
            this.registerNativeAutomaticUiTraceHandler();
        } else {
            this.registerCPAutomaticUiTraceHandler();
        }
    }

    private final Unit clearUiHangsIfNotEnabled() {
        Unit unit;
        UiTracesManagerImpl uiTracesManagerImpl = object;
        Object object = uiTracesManagerImpl.repo;
        if (uiTracesManagerImpl.configurationProvider.isAutoUiHangsEnabled()) {
            object = null;
        }
        if (object != null) {
            object.clearUiHangs();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final void stopAutomaticUiTraces() {
        UiTracesManagerImpl uiTracesManagerImpl = this;
        uiTracesManagerImpl.unregisterNativeAutomaticUiTraceHandler();
        uiTracesManagerImpl.unregisterCPAutomaticUiTraceHandler();
        uiTracesManagerImpl.repo.clearAll();
    }

    private final APMUiTraceActivityCallbacks onCustomUiTraceStateChanged() {
        APMUiTraceActivityCallbacks aPMUiTraceActivityCallbacks = ((UiTracesManagerImpl)((Object)aPMUiTraceActivityCallbacks2)).customUiTracesHandlerActivityCallbacksProvider.invoke();
        APMUiTraceActivityCallbacks aPMUiTraceActivityCallbacks2 = aPMUiTraceActivityCallbacks != null ? (((UiTracesManagerImpl)((Object)aPMUiTraceActivityCallbacks2)).getCanCaptureCustomUiTraces() ? ((UiTracesManagerImpl)((Object)aPMUiTraceActivityCallbacks2)).start(aPMUiTraceActivityCallbacks) : ((UiTracesManagerImpl)((Object)aPMUiTraceActivityCallbacks2)).stop(aPMUiTraceActivityCallbacks)) : null;
        return aPMUiTraceActivityCallbacks2;
    }

    private final void registerNativeAutomaticUiTraceHandler() {
        if (this.nativeAutomaticUiTraceHandler == null) {
            UiTracesManagerImpl uiTracesManagerImpl = this;
            uiTracesManagerImpl.nativeAutomaticUiTraceHandler = uiTracesManagerImpl.start(uiTracesManagerImpl.nativeAutomaticUiTraceHandlerProvider.invoke());
        }
    }

    private final void unregisterNativeAutomaticUiTraceHandler() {
        APMUiTraceActivityCallbacks aPMUiTraceActivityCallbacks = this.nativeAutomaticUiTraceHandler;
        if (aPMUiTraceActivityCallbacks != null) {
            this.stop(aPMUiTraceActivityCallbacks);
        }
        this.nativeAutomaticUiTraceHandler = null;
    }

    private final void registerCPAutomaticUiTraceHandler() {
        if (((UiTracesManagerImpl)((Object)cPAutomaticUiTracesHandlerImpl)).cpAutomaticUiTraceHandler == null) {
            UiTracesManagerImpl uiTracesManagerImpl = cPAutomaticUiTracesHandlerImpl;
            CPAutomaticUiTracesHandlerImpl cPAutomaticUiTracesHandlerImpl = uiTracesManagerImpl.cpAutomaticUiTraceHandlerProvider.invoke();
            uiTracesManagerImpl.start(cPAutomaticUiTracesHandlerImpl);
            uiTracesManagerImpl.cpAutomaticUiTraceHandler = cPAutomaticUiTracesHandlerImpl;
        }
    }

    private final void unregisterCPAutomaticUiTraceHandler() {
        CPAutomaticUiTracesHandlerImpl cPAutomaticUiTracesHandlerImpl = this.cpAutomaticUiTraceHandler;
        if (cPAutomaticUiTracesHandlerImpl != null) {
            this.stop(cPAutomaticUiTracesHandlerImpl);
        }
        this.cpAutomaticUiTraceHandler = null;
    }

    private final APMUiTraceActivityCallbacks start(APMUiTraceActivityCallbacks aPMUiTraceActivityCallbacks) {
        aPMUiTraceActivityCallbacks.observeAPMSessions();
        this.compositeApmUiTraceActivityCallbacks.add(aPMUiTraceActivityCallbacks);
        return aPMUiTraceActivityCallbacks;
    }

    private final APMUiTraceActivityCallbacks stop(APMUiTraceActivityCallbacks aPMUiTraceActivityCallbacks) {
        aPMUiTraceActivityCallbacks.stopObservingAPMSessions();
        this.compositeApmUiTraceActivityCallbacks.remove(aPMUiTraceActivityCallbacks);
        return aPMUiTraceActivityCallbacks;
    }

    private final long getEndTimeInMicros() {
        EventTimeMetricCapture eventTimeMetricCapture;
        UiTracesManagerImpl uiTracesManagerImpl = eventTimeMetricCapture2;
        EventTimeMetricCapture eventTimeMetricCapture2 = eventTimeMetricCapture;
        eventTimeMetricCapture = new EventTimeMetricCapture();
        return uiTracesManagerImpl.isNativeApp() ? eventTimeMetricCapture2.getMicroTime() : eventTimeMetricCapture2.getTimeStampMicro();
    }

    private static final void start$lambda$0(UiTracesManagerImpl uiTracesManagerImpl) {
        UiTracesManagerImpl uiTracesManagerImpl2 = uiTracesManagerImpl;
        Intrinsics.checkNotNullParameter((Object)uiTracesManagerImpl2, (String)"this$0");
        uiTracesManagerImpl2.startSynchronous();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void onStateChanged$lambda$3(UiTracesManagerImpl object) {
        Object object2;
        Logger logger2;
        block5: {
            Object object3 = object;
            Intrinsics.checkNotNullParameter((Object)object3, (String)"this$0");
            object = "Error while handling UiTrace feature state changed";
            logger2 = ((UiTracesManagerImpl)object3).logger;
            try {
                // empty try
            }
            catch (Throwable throwable) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                break block5;
            }
            {
                super.onAutomaticUiTracesStateChanged();
                super.onCustomUiTraceStateChanged();
            }
            {
                object2 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
        }
        object2 = Result.exceptionOrNull-impl((Object)object2);
        if (object2 != null) {
            ExceptionUtilKt.reportAndLogError(logger2, (String)object, (Throwable)object2);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void endAll$lambda$6(UiTracesManagerImpl object, long l) {
        Logger logger2;
        String string;
        block7: {
            Throwable throwable2;
            block5: {
                block6: {
                    Activity activity;
                    UiTracesManagerImpl uiTracesManagerImpl = object;
                    Intrinsics.checkNotNullParameter((Object)uiTracesManagerImpl, (String)"this$0");
                    string = "An error occurred while ending all UiTraces";
                    logger2 = uiTracesManagerImpl.logger;
                    try {
                        // empty try
                    }
                    catch (Throwable throwable2) {
                        break block5;
                    }
                    {
                        activity = uiTracesManagerImpl.internalTrackingDelegate.getCurrentActivity();
                        if (activity == null) break block6;
                    }
                    ((UiTracesManagerImpl)object).repo.endAll(UiTraceUtilsKt.getUiTraceEndParams(activity, ((UiTracesManagerImpl)object).deviceStateProvider, l));
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
                break block7;
            }
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
        }
        object = Result.exceptionOrNull-impl((Object)object);
        if (object != null) {
            ExceptionUtilKt.reportAndLogError(logger2, string, (Throwable)object);
        }
    }

    @Override
    public void start() {
        this.executor.execute(() -> UiTracesManagerImpl.start$lambda$0(this));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startSynchronous() {
        Throwable throwable2;
        Logger logger2;
        String string;
        block7: {
            APMUiTraceActivityCallbacks aPMUiTraceActivityCallbacks;
            UiTracesManagerImpl uiTracesManagerImpl = object;
            string = "Error while initializing Ui traces feature";
            logger2 = uiTracesManagerImpl.logger;
            try {
                // empty try
            }
            catch (Throwable throwable2) {}
            if (!uiTracesManagerImpl.getCanCaptureCustomUiTraces() || (aPMUiTraceActivityCallbacks = ((UiTracesManagerImpl)object).customUiTracesHandlerActivityCallbacksProvider.invoke()) == null) break block7;
            super.start(aPMUiTraceActivityCallbacks);
        }
        if (((UiTracesManagerImpl)object).configurationProvider.isUiTraceEnabled()) {
            super.startAutomaticUiTraces();
        }
        Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
        object = Result.exceptionOrNull-impl((Object)object);
        if (object != null) {
            ExceptionUtilKt.reportAndLogError(logger2, string, (Throwable)object);
        }
    }

    @Override
    public void onStateChanged() {
        this.executor.execute(() -> UiTracesManagerImpl.onStateChanged$lambda$3(this));
    }

    @Override
    public void endAll() {
        UiTracesManagerImpl uiTracesManagerImpl = this;
        long l = uiTracesManagerImpl.getEndTimeInMicros();
        uiTracesManagerImpl.executor.execute(() -> UiTracesManagerImpl.endAll$lambda$6(this, l));
    }

    @Override
    public void onScreenChanged(@Nullable String string, long l, long l2) {
        CPAutomaticUiTracesHandlerImpl cPAutomaticUiTracesHandlerImpl = ((UiTracesManagerImpl)((Object)cPAutomaticUiTracesHandlerImpl)).cpAutomaticUiTraceHandler;
        if (cPAutomaticUiTracesHandlerImpl != null) {
            cPAutomaticUiTracesHandlerImpl.onScreenChanged(string, l, l2);
        }
    }

    @Override
    public void onScreenChangedSync(@Nullable String string, long l, long l2) {
        CPAutomaticUiTracesHandlerImpl cPAutomaticUiTracesHandlerImpl = ((UiTracesManagerImpl)((Object)cPAutomaticUiTracesHandlerImpl)).cpAutomaticUiTraceHandler;
        if (cPAutomaticUiTracesHandlerImpl != null) {
            cPAutomaticUiTracesHandlerImpl.onScreenChangedSync(string, l, l2);
        }
    }
}

