/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.uitrace.handler;

import com.instabug.apm.cache.handler.session.SessionMetaDataCacheHandler;
import com.instabug.apm.cache.handler.uitrace.UiTraceCacheHandler;
import com.instabug.apm.cache.model.UiTraceCacheModel;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.uitrace.handler.UiTraceHandler;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\rH\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\rH\u0016J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/instabug/apm/uitrace/handler/UiTraceHandlerImpl;", "Lcom/instabug/apm/uitrace/handler/UiTraceHandler;", "cacheHandler", "Lcom/instabug/apm/cache/handler/uitrace/UiTraceCacheHandler;", "metaDataCacheHandler", "Lcom/instabug/apm/cache/handler/session/SessionMetaDataCacheHandler;", "configurationProvider", "Lcom/instabug/apm/configuration/APMConfigurationProvider;", "logger", "Lcom/instabug/apm/logger/internal/Logger;", "(Lcom/instabug/apm/cache/handler/uitrace/UiTraceCacheHandler;Lcom/instabug/apm/cache/handler/session/SessionMetaDataCacheHandler;Lcom/instabug/apm/configuration/APMConfigurationProvider;Lcom/instabug/apm/logger/internal/Logger;)V", "countsUpdated", "", "Lcom/instabug/apm/cache/model/UiTraceCacheModel;", "getCountsUpdated", "(Lcom/instabug/apm/cache/model/UiTraceCacheModel;)Z", "inserted", "getInserted", "end", "", "cacheModel", "insertOrUpdate", "removeAll", "removeUiHangs", "saveIfPossible", "uiTraceCacheModel", "updateCountsAndTrim", "(Lcom/instabug/apm/cache/model/UiTraceCacheModel;)Lkotlin/Unit;", "instabug-apm_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nUiTraceHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiTraceHandler.kt\ncom/instabug/apm/uitrace/handler/UiTraceHandlerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class UiTraceHandlerImpl
implements UiTraceHandler {
    @NotNull
    private final UiTraceCacheHandler cacheHandler;
    @NotNull
    private final SessionMetaDataCacheHandler metaDataCacheHandler;
    @NotNull
    private final APMConfigurationProvider configurationProvider;
    @NotNull
    private final Logger logger;

    public UiTraceHandlerImpl(@NotNull UiTraceCacheHandler uiTraceCacheHandler, @NotNull SessionMetaDataCacheHandler sessionMetaDataCacheHandler, @NotNull APMConfigurationProvider aPMConfigurationProvider, @NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)uiTraceCacheHandler, (String)"cacheHandler");
        Intrinsics.checkNotNullParameter((Object)sessionMetaDataCacheHandler, (String)"metaDataCacheHandler");
        Intrinsics.checkNotNullParameter((Object)aPMConfigurationProvider, (String)"configurationProvider");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.cacheHandler = uiTraceCacheHandler;
        this.metaDataCacheHandler = sessionMetaDataCacheHandler;
        this.configurationProvider = aPMConfigurationProvider;
        this.logger = logger2;
    }

    private final boolean getInserted(UiTraceCacheModel uiTraceCacheModel) {
        return uiTraceCacheModel.cacheStateIncludes((byte)1);
    }

    private final boolean getCountsUpdated(UiTraceCacheModel uiTraceCacheModel) {
        return uiTraceCacheModel.cacheStateIncludes((byte)4);
    }

    private final boolean insertOrUpdate(UiTraceCacheModel uiTraceCacheModel) {
        boolean bl;
        if (!this.getInserted(uiTraceCacheModel)) {
            UiTraceHandlerImpl uiTraceHandlerImpl = this;
            uiTraceHandlerImpl.saveIfPossible(uiTraceCacheModel);
            bl = uiTraceHandlerImpl.getInserted(uiTraceCacheModel);
        } else if (uiTraceCacheModel.getSessionId() != null) {
            bl = this.cacheHandler.update(uiTraceCacheModel) > 0;
        } else {
            this.logger.logSDKProtected("UITrace was not updated. APM session is null");
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Unit updateCountsAndTrim(UiTraceCacheModel uiTraceCacheModel) {
        int n;
        if (!this.getInserted(uiTraceCacheModel)) return null;
        if (uiTraceCacheModel == null) return null;
        if (this.getCountsUpdated(uiTraceCacheModel)) return null;
        if (uiTraceCacheModel == null) return null;
        String string = uiTraceCacheModel.getSessionId();
        if (string == null) return null;
        if (this.metaDataCacheHandler.addToUITracesTotalCount(string, 1)) {
            uiTraceCacheModel.updateCacheState((byte)4);
        }
        if ((n = this.cacheHandler.trimToLimit(string, this.configurationProvider.getUiTraceLimitPerRequest())) > 0) {
            this.metaDataCacheHandler.addToUITracesDroppedCount(string, n);
        }
        UiTraceHandlerImpl uiTraceHandlerImpl = this;
        uiTraceHandlerImpl.cacheHandler.clearPreviousUnEndedTraces(string);
        uiTraceHandlerImpl.cacheHandler.trimToLimit(this.configurationProvider.getUiTraceStoreLimit());
        return Unit.INSTANCE;
    }

    @Override
    public void saveIfPossible(@NotNull UiTraceCacheModel uiTraceCacheModel) {
        UiTraceCacheModel uiTraceCacheModel2 = uiTraceCacheModel;
        Intrinsics.checkNotNullParameter((Object)uiTraceCacheModel2, (String)"uiTraceCacheModel");
        UiTraceCacheModel uiTraceCacheModel3 = uiTraceCacheModel2.getSessionId() != null ? uiTraceCacheModel : null;
        if (uiTraceCacheModel3 != null) {
            if (((UiTraceHandlerImpl)object).getInserted(uiTraceCacheModel3)) {
                uiTraceCacheModel3 = null;
            }
            if (uiTraceCacheModel3 != null) {
                Object object = ((UiTraceHandlerImpl)object).cacheHandler.insert(uiTraceCacheModel3);
                if (((Number)object).longValue() == -1L) {
                    object = null;
                }
                if (object != null) {
                    uiTraceCacheModel.updateCacheState((byte)1);
                }
            }
        }
    }

    @Override
    public void end(@NotNull UiTraceCacheModel uiTraceCacheModel) {
        UiTraceCacheModel uiTraceCacheModel2 = uiTraceCacheModel;
        Intrinsics.checkNotNullParameter((Object)uiTraceCacheModel2, (String)"cacheModel");
        if (this.insertOrUpdate(uiTraceCacheModel2)) {
            this.updateCountsAndTrim(uiTraceCacheModel);
        } else {
            this.logger.logSDKProtected("Session meta data was not updated. Failed to update UITrace");
        }
    }

    @Override
    public void removeAll() {
        UiTraceHandlerImpl uiTraceHandlerImpl = this;
        uiTraceHandlerImpl.cacheHandler.removeAll();
        uiTraceHandlerImpl.metaDataCacheHandler.resetUITracesCounts();
    }

    @Override
    public void removeUiHangs() {
        this.cacheHandler.removeUiHangs();
    }
}

