/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.screenloading;

import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.configuration.FeatureAvailabilityChecker;
import com.instabug.apm.logger.internal.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/instabug/apm/screenloading/ScreenLoadingFeatureAvailabilityChecker;", "Lcom/instabug/apm/configuration/FeatureAvailabilityChecker;", "configurationProvider", "Lcom/instabug/apm/configuration/APMConfigurationProvider;", "logger", "Lcom/instabug/apm/logger/internal/Logger;", "(Lcom/instabug/apm/configuration/APMConfigurationProvider;Lcom/instabug/apm/logger/internal/Logger;)V", "isAvailable", "", "apiName", "", "returnDisabledAndLogError", "message", "Companion", "instabug-apm_defaultUiRelease"})
public final class ScreenLoadingFeatureAvailabilityChecker
implements FeatureAvailabilityChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final APMConfigurationProvider configurationProvider;
    @NotNull
    private final Logger logger;

    public ScreenLoadingFeatureAvailabilityChecker(@NotNull APMConfigurationProvider aPMConfigurationProvider, @NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)aPMConfigurationProvider, (String)"configurationProvider");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.configurationProvider = aPMConfigurationProvider;
        this.logger = logger2;
    }

    private final boolean returnDisabledAndLogError(String string) {
        this.logger.logSDKError(string);
        return false;
    }

    @Override
    public boolean isAvailable(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"apiName");
        return !this.configurationProvider.isAPMFeatureAvailable() ? this.returnDisabledAndLogError(string + " wasn\u2019t called as the feature seems to be disabled for your company on Instabug. Please contact Instabug\u2019s support team from your dashboard for more information.") : (!this.configurationProvider.isAPMSdkEnabled() ? this.returnDisabledAndLogError(string + " wasn't called. Please make sure to enable APM first by following the instructions at this link: https://docs.instabug.com/reference#enable-or-disable-apm") : (!this.configurationProvider.isUiTraceSdkEnabled() ? this.returnDisabledAndLogError(string + " wasn't called. Please make sure to enable Auto UI Traces first by following the instructions at this link: https://docs.instabug.com/reference/enable-or-disable-auto-ui-trace") : (!this.configurationProvider.isUiLoadingMetricsFeatureEnabled() ? this.returnDisabledAndLogError(string + " wasn\u2019t called as the feature seems to be disabled for your company on Instabug. Please contact Instabug\u2019s support team from your dashboard for more information.") : (!this.configurationProvider.isUiLoadingMetricsSdkEnabled() ? this.returnDisabledAndLogError(string + " wasn't called. Please make sure to enable Screen Loading first by following the instructions at this link: https://docs.instabug.com/reference/enable-or-disable-screen-loading") : true))));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/instabug/apm/screenloading/ScreenLoadingFeatureAvailabilityChecker$Companion;", "", "()V", "APM_SDK_DISABLED", "", "FEATURE_NOT_AVAILABLE", "SCREEN_LOADING_SDK_DISABLED", "UI_TRACE_SDK_DISABLED", "instabug-apm_defaultUiRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

