/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.networking;

import androidx.annotation.Nullable;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.di.InterceptorsServiceLocator;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.networkinterception.APMNetworkLogWrapper;
import com.instabug.apm.networkinterception.cp.APMCPNetworkLog;
import com.instabug.apm.networkinterception.cp.ExtensionsKt;
import com.instabug.library.apichecker.APIChecker;
import com.instabug.library.util.threading.ThreadUtils;

public class APMNetworkLogger {
    @Nullable
    private APMNetworkLogWrapper networkLogWrapper;
    private final Logger apmLogger = ServiceLocator.getApmLogger();

    public APMNetworkLogger() {
        this.networkLogWrapper = new APMNetworkLogWrapper();
    }

    private void log(long l, long l2, String string, String string2, long l3, String string3, String string4, String string5, String string6, String string7, long l4, int n, String string8, String string9, @Nullable String string10, @Nullable String string11, @Nullable APMCPNetworkLog.W3CExternalTraceAttributes w3CExternalTraceAttributes) {
        ThreadUtils.getCurrentThreadStackTrace();
        APIChecker.checkAndRunInExecutor((String)"APMNetworkLogger.log", () -> {
            APMNetworkLogWrapper aPMNetworkLogWrapper = this.networkLogWrapper;
            if (aPMNetworkLogWrapper == null) {
                APMNetworkLogWrapper aPMNetworkLogWrapper2;
                aPMNetworkLogWrapper = aPMNetworkLogWrapper2;
                aPMNetworkLogWrapper2 = new APMNetworkLogWrapper();
            }
            boolean bl = string10 != null;
            boolean bl2 = false;
            APMConfigurationProvider aPMConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
            if (aPMConfigurationProvider != null) {
                bl2 = aPMConfigurationProvider.isNetworkGraphQlFeatureEnabled();
            }
            Object var26_22 = null;
            if (string11 == null || string11.isEmpty()) {
                string11 = var26_22;
            }
            aPMNetworkLogWrapper.setStartTime(l);
            aPMNetworkLogWrapper.setTotalDuration(l2);
            aPMNetworkLogWrapper.setRequestHeaders(string);
            aPMNetworkLogWrapper.setRequestBody(string2);
            aPMNetworkLogWrapper.setRequestBodySize(l3);
            aPMNetworkLogWrapper.setMethod(string3);
            aPMNetworkLogWrapper.setUrl(string4);
            aPMNetworkLogWrapper.setRequestContentType(string5);
            aPMNetworkLogWrapper.setResponseHeaders(string6);
            aPMNetworkLogWrapper.setResponseBody(string7);
            aPMNetworkLogWrapper.setResponseBodySize(l4);
            aPMNetworkLogWrapper.setResponseCode(n);
            aPMNetworkLogWrapper.setResponseContentType(string8);
            aPMNetworkLogWrapper.setErrorMessage(string9);
            if (bl2 && bl) {
                APMNetworkLogWrapper aPMNetworkLogWrapper3 = aPMNetworkLogWrapper;
                aPMNetworkLogWrapper3.setGraphQlQueryName(string10);
                aPMNetworkLogWrapper3.setServerSideErrorMessage(string11);
            } else if (!bl) {
                aPMNetworkLogWrapper.setServerSideErrorMessage(string11);
            }
            APMNetworkLogWrapper aPMNetworkLogWrapper4 = aPMNetworkLogWrapper;
            ExtensionsKt.populateExternalTraceAttributes(aPMNetworkLogWrapper4, w3CExternalTraceAttributes, aPMConfigurationProvider);
            this.networkLogWrapper = aPMNetworkLogWrapper4;
            aPMNetworkLogWrapper.insert(null, InterceptorsServiceLocator.getApmNetworkLoggerSanitizer());
            this.apmLogger.logSDKDebug("adding network log: " + this.networkLogWrapper.toString() + "\n");
            this.networkLogWrapper = null;
        });
    }
}

