/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.logger.internal;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.library.util.InstabugSDKLogger;

public class Logger {
    @NonNull
    private final APMConfigurationProvider configurationProvider;

    public Logger(@NonNull APMConfigurationProvider aPMConfigurationProvider) {
        this.configurationProvider = aPMConfigurationProvider;
    }

    public void logSDKVerbose(@NonNull String string) {
        Logger logger2 = this;
        logger2.v(string);
        logger2.logSDKProtected(string);
    }

    public void logSDKInfo(@NonNull String string) {
        Logger logger2 = this;
        logger2.i(string);
        logger2.logSDKProtected(string);
    }

    public void logSDKDebug(@NonNull String string) {
        Logger logger2 = this;
        logger2.d(string);
        logger2.logSDKProtected(string);
    }

    public void logSDKWarning(@NonNull String string) {
        Logger logger2 = this;
        logger2.w(string);
        logger2.logSDKProtected(string);
    }

    public void logSDKError(@NonNull String string, @NonNull Throwable throwable) {
        Logger logger2 = this;
        logger2.e(string + ". " + throwable.toString());
        logger2.logSDKProtected(string + ". " + throwable.toString());
    }

    public void logSDKErrorWithStackTrace(@NonNull String string, @NonNull Throwable throwable) {
        this.logSDKErrorProtected(string, throwable);
    }

    public void logSDKError(@NonNull String string) {
        Logger logger2 = this;
        logger2.e(string);
        logger2.logSDKProtected(string);
    }

    public void logSDKProtected(@NonNull String string) {
        InstabugSDKLogger.p((String)"IBG-APM", (String)string);
    }

    public void logSDKErrorProtected(@NonNull String string, Throwable throwable) {
        InstabugSDKLogger.e((String)"IBG-APM", (String)string, (Throwable)throwable);
    }

    public void v(String string) {
        if (this.shouldPrintLog(5)) {
            Log.v((String)"IBG-APM", (String)string);
        }
    }

    public void i(String string) {
        if (this.shouldPrintLog(3)) {
            Log.i((String)"IBG-APM", (String)string);
        }
    }

    public void d(String string) {
        if (this.shouldPrintLog(4)) {
            Log.d((String)"IBG-APM", (String)string);
        }
    }

    public void w(String string) {
        if (this.shouldPrintLog(2)) {
            Log.w((String)"IBG-APM", (String)string);
        }
    }

    public void e(String string) {
        if (this.shouldPrintLog(1)) {
            Log.e((String)"IBG-APM", (String)string);
        }
    }

    @VisibleForTesting
    boolean shouldPrintLog(int n) {
        int n2 = this.configurationProvider.getLogLevel();
        return n2 != 0 && n <= n2;
    }
}

