/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.lifecycle;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.handler.session.APMSessionObserver;
import com.instabug.apm.handler.session.SessionObserverHandler;
import com.instabug.apm.lifecycle.AppLaunchLifeCycleCallbacks;
import com.instabug.apm.model.EventTimeMetricCapture;
import com.instabug.apm.screenloading.di.ScreenLoadingServiceLocator;
import com.instabug.apm.screenloading.manager.ScreenLoadingManager;
import com.instabug.apm.uitrace.activitycallbacks.APMUiTraceActivityCallbacks;
import com.instabug.apm.uitrace.di.UiTracesServiceLocator;
import com.instabug.apm.uitrace.manager.UiTracesManager;
import com.instabug.library.model.common.Session;

public class ActivityCallbacks
implements Application.ActivityLifecycleCallbacks,
APMSessionObserver {
    private static boolean isRegistered = false;
    @NonNull
    private final AppLaunchLifeCycleCallbacks appLaunchLifeCycleCallbacks;
    @NonNull
    private final APMUiTraceActivityCallbacks uiTraceCallbacks;
    private int activitiesInForegroundCount;

    @SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED", "NewApi"})
    public ActivityCallbacks(Context context, boolean bl) {
        ActivityCallbacks activityCallbacks = this;
        ActivityCallbacks activityCallbacks2 = this;
        activityCallbacks2.activitiesInForegroundCount = 0;
        ActivityCallbacks.setRegistered();
        SessionObserverHandler.register(activityCallbacks2);
        activityCallbacks.appLaunchLifeCycleCallbacks = ServiceLocator.getAppLaunchLifeCycleCallbacks(context, bl);
        activityCallbacks.uiTraceCallbacks = UiTracesServiceLocator.getApmUiTraceActivityCallbacks();
        ActivityCallbacks.startUiTraces();
        ActivityCallbacks.initScreenLoading();
    }

    private static void startUiTraces() {
        UiTracesManager uiTracesManager = UiTracesServiceLocator.getManager();
        if (uiTracesManager != null) {
            uiTracesManager.startSynchronous();
        }
    }

    private static APMConfigurationProvider getApmConfigurationProvider() {
        return ServiceLocator.getApmConfigurationProvider();
    }

    private static void initScreenLoading() {
        if (!ActivityCallbacks.getApmConfigurationProvider().isAutoUiLoadingMetricsFullyEnabled()) {
            return;
        }
        ScreenLoadingManager screenLoadingManager = ScreenLoadingServiceLocator.getManager();
        if (screenLoadingManager != null) {
            screenLoadingManager.startSynchronous();
        }
    }

    public static boolean isRegistered() {
        return isRegistered;
    }

    private static void setRegistered() {
        isRegistered = true;
    }

    public void onActivityPreCreated(@NonNull Activity activity, @Nullable Bundle bundle) {
        EventTimeMetricCapture eventTimeMetricCapture;
        ActivityCallbacks activityCallbacks = eventTimeMetricCapture2;
        EventTimeMetricCapture eventTimeMetricCapture2 = eventTimeMetricCapture;
        eventTimeMetricCapture = new EventTimeMetricCapture();
        long l = eventTimeMetricCapture2.getTimeStampMillis();
        activityCallbacks.uiTraceCallbacks.onActivityPreCreated(activity, bundle, eventTimeMetricCapture2, l);
    }

    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle bundle) {
        EventTimeMetricCapture eventTimeMetricCapture;
        ActivityCallbacks activityCallbacks = eventTimeMetricCapture2;
        EventTimeMetricCapture eventTimeMetricCapture2 = eventTimeMetricCapture;
        eventTimeMetricCapture = new EventTimeMetricCapture();
        long l = eventTimeMetricCapture2.getTimeStampMillis();
        activityCallbacks.uiTraceCallbacks.onActivityCreated(activity, bundle, eventTimeMetricCapture2, l);
        activityCallbacks.appLaunchLifeCycleCallbacks.onActivityCreated(activity, eventTimeMetricCapture2);
    }

    public void onActivityPostCreated(@NonNull Activity activity, @Nullable Bundle bundle) {
        EventTimeMetricCapture eventTimeMetricCapture;
        ActivityCallbacks activityCallbacks = eventTimeMetricCapture2;
        EventTimeMetricCapture eventTimeMetricCapture2 = eventTimeMetricCapture;
        eventTimeMetricCapture = new EventTimeMetricCapture();
        activityCallbacks.uiTraceCallbacks.onActivityPostCreated(activity, bundle, eventTimeMetricCapture2);
    }

    public void onActivityPreStarted(@NonNull Activity activity) {
        EventTimeMetricCapture eventTimeMetricCapture;
        ActivityCallbacks activityCallbacks = eventTimeMetricCapture2;
        EventTimeMetricCapture eventTimeMetricCapture2 = eventTimeMetricCapture;
        eventTimeMetricCapture = new EventTimeMetricCapture();
        activityCallbacks.uiTraceCallbacks.onActivityPreStarted(activity, eventTimeMetricCapture2);
    }

    public void onActivityStarted(@NonNull Activity activity) {
        EventTimeMetricCapture eventTimeMetricCapture;
        ActivityCallbacks activityCallbacks = eventTimeMetricCapture2;
        ++activityCallbacks.activitiesInForegroundCount;
        EventTimeMetricCapture eventTimeMetricCapture2 = eventTimeMetricCapture;
        eventTimeMetricCapture = new EventTimeMetricCapture();
        activityCallbacks.uiTraceCallbacks.onActivityStarted(activity, eventTimeMetricCapture2);
        activityCallbacks.appLaunchLifeCycleCallbacks.onActivityStarted(activity, eventTimeMetricCapture2);
    }

    public void onActivityPostStarted(@NonNull Activity activity) {
        EventTimeMetricCapture eventTimeMetricCapture;
        ActivityCallbacks activityCallbacks = eventTimeMetricCapture2;
        EventTimeMetricCapture eventTimeMetricCapture2 = eventTimeMetricCapture;
        eventTimeMetricCapture = new EventTimeMetricCapture();
        activityCallbacks.uiTraceCallbacks.onActivityPostStarted(activity, eventTimeMetricCapture2);
    }

    public void onActivityPreResumed(@NonNull Activity activity) {
        EventTimeMetricCapture eventTimeMetricCapture;
        ActivityCallbacks activityCallbacks = eventTimeMetricCapture2;
        EventTimeMetricCapture eventTimeMetricCapture2 = eventTimeMetricCapture;
        eventTimeMetricCapture = new EventTimeMetricCapture();
        activityCallbacks.uiTraceCallbacks.onActivityPreResumed(activity, eventTimeMetricCapture2);
    }

    public void onActivityResumed(@NonNull Activity activity) {
        EventTimeMetricCapture eventTimeMetricCapture;
        ActivityCallbacks activityCallbacks = eventTimeMetricCapture2;
        EventTimeMetricCapture eventTimeMetricCapture2 = eventTimeMetricCapture;
        eventTimeMetricCapture = new EventTimeMetricCapture();
        long l = eventTimeMetricCapture2.getTimeStampMillis();
        activityCallbacks.uiTraceCallbacks.onActivityResumed(activity, eventTimeMetricCapture2, l);
        activityCallbacks.appLaunchLifeCycleCallbacks.onActivityResumed(activity, eventTimeMetricCapture2);
    }

    public void onActivityPostResumed(@NonNull Activity activity) {
        EventTimeMetricCapture eventTimeMetricCapture;
        ActivityCallbacks activityCallbacks = eventTimeMetricCapture2;
        EventTimeMetricCapture eventTimeMetricCapture2 = eventTimeMetricCapture;
        eventTimeMetricCapture = new EventTimeMetricCapture();
        activityCallbacks.uiTraceCallbacks.onActivityPostResumed(activity, eventTimeMetricCapture2);
    }

    public void onActivityPaused(@NonNull Activity activity) {
        EventTimeMetricCapture eventTimeMetricCapture;
        ActivityCallbacks activityCallbacks = eventTimeMetricCapture2;
        EventTimeMetricCapture eventTimeMetricCapture2 = eventTimeMetricCapture;
        eventTimeMetricCapture = new EventTimeMetricCapture();
        activityCallbacks.uiTraceCallbacks.onActivityPaused(activity, eventTimeMetricCapture2);
    }

    public void onActivityStopped(@NonNull Activity activity) {
        int n = this.activitiesInForegroundCount;
        if (n != 0) {
            this.activitiesInForegroundCount = n - 1;
        }
        ActivityCallbacks activityCallbacks = this;
        APMUiTraceActivityCallbacks aPMUiTraceActivityCallbacks = activityCallbacks.uiTraceCallbacks;
        boolean bl = activityCallbacks.activitiesInForegroundCount == 0;
        aPMUiTraceActivityCallbacks.onActivityStopped(activity, bl);
        this.appLaunchLifeCycleCallbacks.onActivityStopped();
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle bundle) {
        this.uiTraceCallbacks.onActivitySaveInstanceState(activity, bundle);
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
        this.uiTraceCallbacks.onActivityDestroyed(activity);
    }

    @Override
    public synchronized void onNewSessionStarted(@NonNull Session session, @Nullable Session session2) {
        this.appLaunchLifeCycleCallbacks.onNewSessionStarted(session);
    }
}

