/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.handler.session;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.handler.session.SessionHandler;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;

public class APMUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    @Nullable
    private Thread.UncaughtExceptionHandler defaultUncaughtExceptionHandler;
    private APMConfigurationProvider apmConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
    private SessionHandler sessionHandler = ServiceLocator.getSessionHandler();

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public APMUncaughtExceptionHandler() {
        this.defaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
    }

    @Override
    public void uncaughtException(@NonNull Thread thread, @NonNull Throwable throwable) {
        if (((APMUncaughtExceptionHandler)this).apmConfigurationProvider.isCrashDetectionEnabled()) {
            SettingsManager.getInstance().setCrashedSession(true);
            InstabugSDKLogger.d((String)"IBG-APM", (String)"ending APM session");
            ((APMUncaughtExceptionHandler)this).sessionHandler.endSession(1);
        }
        if ((this = ((APMUncaughtExceptionHandler)this).defaultUncaughtExceptionHandler) != null) {
            this.uncaughtException(thread, throwable);
        }
    }
}

