/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.handler.networklog;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.apm.cache.handler.networklog.DanglingNetworkLogCacheHandler;
import com.instabug.apm.cache.handler.networklog.NetworkLogCacheHandler;
import com.instabug.apm.cache.handler.session.SessionMetaDataCacheHandler;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.handler.networklog.NetworkLogHandler;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.model.APMNetworkLog;
import com.instabug.library.Instabug;
import java.util.List;
import java.util.Map;

@WorkerThread
public class NetworkLogHandlerImpl
implements NetworkLogHandler {
    private final NetworkLogCacheHandler networkLogCacheHandler = ServiceLocator.getNetworkLogCacheHandler();
    private final DanglingNetworkLogCacheHandler danglingNetworkLogCacheHandler = ServiceLocator.getDanglingNetworkLogCacheHandler();
    private final Logger apmLogger = ServiceLocator.getApmLogger();
    @Nullable
    private final SessionMetaDataCacheHandler sessionMetaDataCacheHandler = ServiceLocator.getSessionMetaDataCacheHandler();

    @Override
    public long insertNetworkLog(@NonNull APMNetworkLog object) {
        String string = object.getSessionId();
        long l = -1L;
        if (Instabug.isBuilt()) {
            APMConfigurationProvider aPMConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
            if (aPMConfigurationProvider.isNetworkEnabled()) {
                if (string == null) {
                    long l2 = this.danglingNetworkLogCacheHandler.insertNetworkLog((APMNetworkLog)object);
                    if (l2 != -1L) {
                        NetworkLogHandlerImpl networkLogHandlerImpl = this;
                        networkLogHandlerImpl.apmLogger.d("Network request added to dangling table: " + object.getUrl());
                        networkLogHandlerImpl.danglingNetworkLogCacheHandler.trimToLimit(aPMConfigurationProvider.getNetworkLogsCacheLimit());
                    }
                    l = l2;
                } else {
                    l = this.networkLogCacheHandler.insertNetworkLog(string, (APMNetworkLog)object);
                    if (l != -1L) {
                        NetworkLogHandlerImpl networkLogHandlerImpl = this;
                        networkLogHandlerImpl.apmLogger.d("Network request added to network table: " + object.getUrl());
                        object = networkLogHandlerImpl.sessionMetaDataCacheHandler;
                        if (object != null) {
                            object.addToNetworkLogsTotalCount(string, 1);
                            int n = this.networkLogCacheHandler.trimToLimit(string, aPMConfigurationProvider.getNetworkLogsRequestLimit());
                            if (n > 0) {
                                NetworkLogHandlerImpl networkLogHandlerImpl2 = this;
                                networkLogHandlerImpl2.apmLogger.d("Network requests dropped count: " + n);
                                networkLogHandlerImpl2.sessionMetaDataCacheHandler.addToNetworkLogsDroppedCount(string, n);
                            }
                        }
                        this.networkLogCacheHandler.trimToLimit(aPMConfigurationProvider.getNetworkLogsCacheLimit());
                    }
                }
                this.apmLogger.d("inserted network log, returning: " + l);
            } else {
                this.apmLogger.d("network log is not inserted apm network logs is disabled");
            }
        }
        return l;
    }

    @Override
    public void updateNetworkLog(APMNetworkLog aPMNetworkLog) {
        if (Instabug.isBuilt() && ServiceLocator.getApmConfigurationProvider().isNetworkEnabled()) {
            if (aPMNetworkLog.getExecutedInBackground()) {
                this.danglingNetworkLogCacheHandler.updateNetworkLog(aPMNetworkLog);
            } else {
                this.networkLogCacheHandler.updateNetworkLog(aPMNetworkLog);
            }
        }
    }

    @Override
    public void cleanUp() {
        ServiceLocator.getSingleThreadPoolExecutor("network_log_stop_thread_executor").execute(() -> {
            NetworkLogHandlerImpl networkLogHandlerImpl = this;
            networkLogHandlerImpl.networkLogCacheHandler.cleanUp();
            networkLogHandlerImpl.danglingNetworkLogCacheHandler.cleanUp();
        });
    }

    @Override
    public void removeAll() {
        NetworkLogHandlerImpl networkLogHandlerImpl = sessionMetaDataCacheHandler;
        networkLogHandlerImpl.apmLogger.logSDKDebug("Clearing cached APM network logs");
        networkLogHandlerImpl.networkLogCacheHandler.removeAll();
        networkLogHandlerImpl.danglingNetworkLogCacheHandler.removeAll();
        SessionMetaDataCacheHandler sessionMetaDataCacheHandler = networkLogHandlerImpl.sessionMetaDataCacheHandler;
        if (sessionMetaDataCacheHandler != null) {
            sessionMetaDataCacheHandler.resetNetworkLogsCounts();
        }
    }

    @Override
    public void removeGraphQlData() {
        NetworkLogHandlerImpl networkLogHandlerImpl = this;
        networkLogHandlerImpl.networkLogCacheHandler.removeGraphQlData();
        networkLogHandlerImpl.danglingNetworkLogCacheHandler.removeGraphQlData();
    }

    @Override
    public void removeGrpcData() {
        NetworkLogHandlerImpl networkLogHandlerImpl = this;
        networkLogHandlerImpl.networkLogCacheHandler.removeGrpcData();
        networkLogHandlerImpl.danglingNetworkLogCacheHandler.removeGrpcData();
    }

    @Override
    @Nullable
    public List<APMNetworkLog> getEndedNetworkLogsForSession(String string) {
        return this.networkLogCacheHandler.getEndedNetworkLogsForSession(string);
    }

    @Override
    public void forceStop() {
        this.cleanUp();
    }

    @Override
    public boolean isValidAttribute(String string, String string2, String string3) {
        if (string2 != null && !string2.trim().isEmpty()) {
            String string4 = string2.trim();
            if (string4.length() > 30) {
                this.apmLogger.logSDKError("Trace attribute \"$s1\" wasn't added to \"$s2\" as it was too long. Please limit attribute key names to 30 characters.".replace("$s1", string2).replace("$s2", string));
                return false;
            }
            if (string3 != null) {
                if ((string3 = string3.trim()).length() == 0) {
                    this.apmLogger.logSDKError("Trace attribute \"$s1\" wasn't added to \"$s2\". Trace attribute value can't be empty string.".replace("$s1", string4).replace("$s2", string));
                    return false;
                }
                if (string3.length() > 60) {
                    this.apmLogger.logSDKError("Trace attribute \"$s1\" wasn't added to \"$s2\" as its value was too long. Please limit trace attribute values to 60 characters.".replace("$s1", string2).replace("$s2", string));
                    return false;
                }
            }
            return true;
        }
        this.apmLogger.logSDKError("Trace attribute wasn't added to \"$s\". Trace attribute key can't be null or empty string.".replace("$s", string));
        return false;
    }

    @Override
    public void addAttribute(long l, String string, boolean bl, String string2, String string3) {
        if (Instabug.isBuilt() && ServiceLocator.getApmConfigurationProvider().isNetworkEnabled()) {
            if (bl) {
                this.danglingNetworkLogCacheHandler.addAttribute(l, string, string2, string3);
            } else {
                this.networkLogCacheHandler.addAttribute(l, string, string2, string3);
            }
        }
    }

    @Override
    public Map<String, String> getTraceAttributes(long l) {
        return this.networkLogCacheHandler.getTraceAttributes(l);
    }

    @Override
    public void clearW3CExternalTraceIdCache() {
        NetworkLogHandlerImpl networkLogHandlerImpl = this;
        networkLogHandlerImpl.networkLogCacheHandler.clearW3CExternalTraceIdCache();
        networkLogHandlerImpl.danglingNetworkLogCacheHandler.clearW3CExternalTraceIdCache();
    }

    @Override
    public void clearGeneratedW3CExternalTraceIdCache() {
        NetworkLogHandlerImpl networkLogHandlerImpl = this;
        networkLogHandlerImpl.networkLogCacheHandler.clearGeneratedW3CExternalTraceIdCache();
        networkLogHandlerImpl.danglingNetworkLogCacheHandler.clearGeneratedW3CExternalTraceIdCache();
    }

    @Override
    public void clearCapturedW3CExternalTraceIdCache() {
        NetworkLogHandlerImpl networkLogHandlerImpl = this;
        networkLogHandlerImpl.networkLogCacheHandler.clearCapturedW3CExternalTraceIdCache();
        networkLogHandlerImpl.danglingNetworkLogCacheHandler.clearCapturedW3CExternalTraceIdCache();
    }

    @Override
    public void clearNetworkSpansData() {
        NetworkLogHandlerImpl networkLogHandlerImpl = this;
        networkLogHandlerImpl.networkLogCacheHandler.clearNetworkSpansData();
        networkLogHandlerImpl.danglingNetworkLogCacheHandler.clearNetworkSpansData();
    }
}

