/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.configuration;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.apm.APMImplementation;
import com.instabug.apm.configuration.APMConfigurationHandler;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.configuration.APMStateProvider;
import com.instabug.apm.configuration.ConfigurationHandler;
import com.instabug.apm.di.Provider;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.handler.experiment.ExperimentHandler;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.networkinterception.configuration.NetworkInterceptionConfigurationProvider;
import com.instabug.library.diagnostics.IBGDiagnostics;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class APMConfigurationHandlerImpl
implements APMConfigurationHandler {
    private final APMConfigurationProvider apmConfigurationProvider;
    @Nullable
    private final NetworkInterceptionConfigurationProvider networkConfigurationProvider;
    private Logger apmLogger = ServiceLocator.getApmLogger();
    private final Provider<ConfigurationHandler[]> sdkConfigurationHandlersProvider;
    private final Provider<ConfigurationHandler[]> apmConfigurationHandlersProvider;
    @NonNull
    private final APMImplementation apmImplementation;

    public APMConfigurationHandlerImpl(APMConfigurationProvider aPMConfigurationProvider, @Nullable NetworkInterceptionConfigurationProvider networkInterceptionConfigurationProvider, Provider<ConfigurationHandler[]> provider, Provider<ConfigurationHandler[]> provider2, @NonNull APMImplementation aPMImplementation) {
        this.apmConfigurationProvider = aPMConfigurationProvider;
        this.networkConfigurationProvider = networkInterceptionConfigurationProvider;
        this.sdkConfigurationHandlersProvider = provider;
        this.apmConfigurationHandlersProvider = provider2;
        this.apmImplementation = aPMImplementation;
    }

    private static void resetConfigurationHandlers(ConfigurationHandler[] configurationHandlerArray) {
        for (ConfigurationHandler configurationHandler : configurationHandlerArray) {
            if (configurationHandler == null) continue;
            configurationHandler.reset();
        }
    }

    private void invokeConfigurationHandlers(JSONObject jSONObject, ConfigurationHandler[] configurationHandlerArray) {
        for (ConfigurationHandler configurationHandler : configurationHandlerArray) {
            if (configurationHandler == null) continue;
            configurationHandler.handleConfigurations(jSONObject);
        }
    }

    private void handleAppLaunchConfigurations(JSONObject jSONObject) {
        if ((jSONObject = jSONObject.optJSONObject("launches")) != null) {
            boolean bl = jSONObject.optBoolean("enabled", false);
            this.apmConfigurationProvider.setColdAppLaunchesFeatureEnabled(bl);
            this.handleHotAppLaunchConfigurations(jSONObject);
            this.handleWarmAppLaunchConfiguration(jSONObject);
            if (!bl) {
                APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = this;
                aPMConfigurationHandlerImpl.resetColdAppLaunchesConfiguration();
                aPMConfigurationHandlerImpl.clearAppLaunchesCache("cold");
            } else {
                long l = jSONObject.optLong("limit_per_request", 200L);
                this.apmConfigurationProvider.setColdAppLaunchesLimitPerRequest(l);
                l = jSONObject.optLong("store_limit", 1000L);
                this.apmConfigurationProvider.setColdAppLaunchesStoreLimit(l);
            }
            boolean bl2 = bl;
            APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = this;
            boolean bl3 = jSONObject.optBoolean("end_api_enabled", false);
            aPMConfigurationHandlerImpl.apmConfigurationProvider.setEndColdAppLaunchFeatureEnabled(bl3);
            bl3 = aPMConfigurationHandlerImpl.apmConfigurationProvider.isHotAppLaunchesFeatureEnabled();
            bl = aPMConfigurationHandlerImpl.apmConfigurationProvider.isWarmAppLaunchFeatureEnabled();
            if (!(bl2 || bl3 || bl)) {
                this.clearAppLaunchesCache();
            }
        } else {
            APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = this;
            aPMConfigurationHandlerImpl.apmLogger.logSDKProtected("Can't parse app launches configurations, object is null.");
            aPMConfigurationHandlerImpl.resetColdAppLaunchesConfiguration();
            aPMConfigurationHandlerImpl.resetHotAppLaunchesConfiguration();
            aPMConfigurationHandlerImpl.resetWarmAppLaunchesConfiguration();
            aPMConfigurationHandlerImpl.clearAppLaunchesCache();
        }
    }

    private void handleHotAppLaunchConfigurations(JSONObject jSONObject) {
        if ((jSONObject = jSONObject.optJSONObject("hot")) != null) {
            boolean bl = jSONObject.optBoolean("enabled", false);
            this.apmConfigurationProvider.setHotAppLaunchesFeatureEnabled(bl);
            if (!bl) {
                APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = this;
                aPMConfigurationHandlerImpl.resetHotAppLaunchesConfiguration();
                aPMConfigurationHandlerImpl.clearAppLaunchesCache("hot");
            } else {
                long l = jSONObject.optLong("limit_per_request", 200L);
                this.apmConfigurationProvider.setHotAppLaunchesLimitPerRequest(l);
                l = jSONObject.optLong("store_limit", 1000L);
                this.apmConfigurationProvider.setHotAppLaunchesStoreLimit(l);
            }
            boolean bl2 = jSONObject.optBoolean("end_api_enabled", false);
            this.apmConfigurationProvider.setEndHotAppLaunchFeatureEnabled(bl2);
        } else {
            this.clearAppLaunchesCache("hot");
        }
    }

    private void handleWarmAppLaunchConfiguration(@NonNull JSONObject jSONObject) {
        if ((jSONObject = jSONObject.optJSONObject("warm")) != null) {
            boolean bl = jSONObject.optBoolean("enabled", false);
            APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = this;
            JSONObject jSONObject2 = jSONObject;
            long l = jSONObject2.optLong("limit_per_request", 200L);
            long l2 = jSONObject2.optLong("store_limit", 1000L);
            boolean bl2 = jSONObject2.optBoolean("end_api_enabled", false);
            aPMConfigurationHandlerImpl.apmConfigurationProvider.setWarmAppLaunchFeatureEnabled(bl);
            aPMConfigurationHandlerImpl.apmConfigurationProvider.setWarmAppLaunchRequestLimit(l);
            aPMConfigurationHandlerImpl.apmConfigurationProvider.setWarmAppLaunchStoreLimit(l2);
            aPMConfigurationHandlerImpl.apmConfigurationProvider.setEndWarmAppLaunchFeatureEnabled(bl2);
            if (!bl) {
                this.clearAppLaunchesCache("warm");
            }
        } else {
            APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = this;
            aPMConfigurationHandlerImpl.resetWarmAppLaunchesConfiguration();
            if (!aPMConfigurationHandlerImpl.apmConfigurationProvider.isWarmAppLaunchFeatureEnabled()) {
                this.clearAppLaunchesCache("warm");
            }
        }
    }

    private void resetColdAppLaunchesConfiguration() {
        APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = this;
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setColdAppLaunchesFeatureEnabled(false);
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setColdAppLaunchesLimitPerRequest(200L);
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setColdAppLaunchesStoreLimit(1000L);
    }

    private void resetHotAppLaunchesConfiguration() {
        APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = this;
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setHotAppLaunchesFeatureEnabled(false);
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setHotAppLaunchesLimitPerRequest(200L);
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setHotAppLaunchesStoreLimit(1000L);
    }

    private void resetWarmAppLaunchesConfiguration() {
        this.apmConfigurationProvider.resetWarmAppLaunchConfigurations();
    }

    private void handleExecutionTracesConfiguration(JSONObject jSONObject) {
        if ((jSONObject = jSONObject.optJSONObject("traces")) != null) {
            boolean bl = jSONObject.optBoolean("enabled", false);
            this.apmConfigurationProvider.setExecutionTraceFeatureEnabled(bl);
            if (!bl) {
                APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = this;
                aPMConfigurationHandlerImpl.resetExecutionTraceConfiguration();
                aPMConfigurationHandlerImpl.clearExecutionTraceCache();
            } else {
                long l = jSONObject.optLong("limit_per_request", 200L);
                this.apmConfigurationProvider.setExecutionTraceLimitPerRequest(l);
                l = jSONObject.optLong("store_limit", 1000L);
                this.apmConfigurationProvider.setExecutionTraceStoreLimit(l);
                int n = jSONObject.optInt("store_attributes_limit", 5);
                this.apmConfigurationProvider.setExecutionTraceStoreAttributesLimit(n);
            }
        } else {
            APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = this;
            aPMConfigurationHandlerImpl.apmLogger.logSDKProtected("Can't parse execution traces configurations, object is null.");
            aPMConfigurationHandlerImpl.resetExecutionTraceConfiguration();
            aPMConfigurationHandlerImpl.clearExecutionTraceCache();
        }
    }

    private boolean handleUiLoadingConfiguration(@Nullable JSONObject jSONObject) {
        if (jSONObject != null) {
            JSONObject jSONObject2 = jSONObject;
            boolean bl = jSONObject2.optBoolean("enabled", false);
            boolean bl2 = jSONObject2.optBoolean("end_api_enabled", false);
            APMConfigurationProvider aPMConfigurationProvider = this.apmConfigurationProvider;
            if (aPMConfigurationProvider != null) {
                aPMConfigurationProvider.setUiLoadingMetricsFeatureEnabled(bl);
                this.apmConfigurationProvider.setEndScreenLoadingFeatureEnabled(bl2);
                return bl;
            }
        }
        return false;
    }

    private void resetUiTraceConfiguration() {
        APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = this;
        aPMConfigurationHandlerImpl.resetUiHangsConfiguration();
        aPMConfigurationHandlerImpl.resetUiLoadingConfiguration();
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setUiTraceLimitPerRequest(200L);
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setUiTraceStoreLimit(1000L);
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setUiTraceLargeDropThreshold(250000.0f);
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setUiTraceSmallDropThreshold(16700.0f);
    }

    private void resetUiHangsConfiguration() {
        APMConfigurationProvider aPMConfigurationProvider = ((APMConfigurationHandlerImpl)((Object)aPMConfigurationProvider)).apmConfigurationProvider;
        if (aPMConfigurationProvider != null) {
            aPMConfigurationProvider.setUiHangsFeatureEnabled(false);
        }
    }

    private void resetUiLoadingConfiguration() {
        APMConfigurationProvider aPMConfigurationProvider = this.apmConfigurationProvider;
        if (aPMConfigurationProvider != null) {
            aPMConfigurationProvider.setUiLoadingMetricsFeatureEnabled(false);
            this.apmConfigurationProvider.setEndScreenLoadingFeatureEnabled(false);
        }
    }

    private void handleNetworkConfiguration(JSONObject jSONObject, JSONObject jSONObject2) {
        if ((jSONObject = jSONObject.optJSONObject("network")) != null) {
            boolean bl = jSONObject.optBoolean("enabled", false);
            this.apmConfigurationProvider.setNetworkEnabled(bl);
            if (!bl) {
                APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = this;
                aPMConfigurationHandlerImpl.resetNetworkConfiguration();
                aPMConfigurationHandlerImpl.clearNetworkLogCache();
            } else {
                long l = jSONObject.optLong("limit_per_request", 200L);
                this.apmConfigurationProvider.setNetworkLogsLimitPerRequest(l);
                l = jSONObject.optLong("store_limit", 1000L);
                this.apmConfigurationProvider.setNetworkLogsStoreLimit(l);
                int n = jSONObject.optInt("store_attributes_limit", 5);
                this.apmConfigurationProvider.setNetworkLogsStoreAttributesLimit(n);
                boolean bl2 = jSONObject.optBoolean("graphql_enabled", false);
                this.apmConfigurationProvider.setNetworkGraphQlFeatureEnabled(bl2);
                if (!bl2) {
                    this.clearGraphQlCache();
                }
                boolean bl3 = jSONObject.optBoolean("grpc_enabled", false);
                this.apmConfigurationProvider.setNetworkGrpcInterceptionFeatureEnabled(bl3);
                if (!bl3) {
                    this.clearGrpcCache();
                }
                this.handleNetworkInterceptionConfigurations(jSONObject, jSONObject2);
            }
        } else {
            APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = this;
            aPMConfigurationHandlerImpl.apmLogger.logSDKProtected("Can't parse network logs configurations, object is null.");
            aPMConfigurationHandlerImpl.resetNetworkConfiguration();
            aPMConfigurationHandlerImpl.clearNetworkLogCache();
        }
        this.handleW3CExternalTraceIdConfigurations();
    }

    private void handleNetworkInterceptionConfigurations(@NonNull JSONObject jSONObject, JSONObject jSONObject2) {
        NetworkInterceptionConfigurationProvider networkInterceptionConfigurationProvider = this.networkConfigurationProvider;
        if (networkInterceptionConfigurationProvider != null) {
            APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = this;
            aPMConfigurationHandlerImpl.parseNetworkSanitizationConfigs(jSONObject, networkInterceptionConfigurationProvider);
            aPMConfigurationHandlerImpl.parseNetworkSpansConfigs(jSONObject, aPMConfigurationHandlerImpl.networkConfigurationProvider);
            boolean bl = jSONObject2 != null ? jSONObject2.optBoolean("cp_native_interception_enabled", true) : true;
            this.networkConfigurationProvider.setCpNativeInterceptionFeatureEnabled(bl);
        }
    }

    private void parseNetworkSpansConfigs(@NonNull JSONObject jSONObject, @NonNull NetworkInterceptionConfigurationProvider networkInterceptionConfigurationProvider) {
        NetworkInterceptionConfigurationProvider networkInterceptionConfigurationProvider2 = networkInterceptionConfigurationProvider;
        networkInterceptionConfigurationProvider2.setNetworkSpansFeatureEnabled(jSONObject.optBoolean("spans_enabled", false));
        if (!networkInterceptionConfigurationProvider2.isNetworkSpansEnabled()) {
            this.apmImplementation.clearNetworkSpansCache();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseNetworkSanitizationConfigs(@NonNull JSONObject object, @NonNull NetworkInterceptionConfigurationProvider networkInterceptionConfigurationProvider) {
        HashSet hashSet;
        networkInterceptionConfigurationProvider.setKeywordSanitizationFeatureEnabled(object.optBoolean("sanitization_enabled", true));
        APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = object.optJSONArray("sanitize_keys");
        if (aPMConfigurationHandlerImpl == null) {
            networkInterceptionConfigurationProvider.resetIBGSanitizationKeywords();
            return;
        }
        object = hashSet;
        try {
            hashSet = new HashSet();
            for (int i = 0; i < aPMConfigurationHandlerImpl.length(); ++i) {
                ((HashSet)object).add(aPMConfigurationHandlerImpl.getString(i));
            }
        }
        catch (JSONException jSONException) {}
        {
            continue;
        }
        networkInterceptionConfigurationProvider.setIBGSanitizationKeywords((Set<String>)object);
        return;
        networkInterceptionConfigurationProvider.resetIBGSanitizationKeywords();
        IBGDiagnostics.reportNonFatal((Throwable)jSONException, (String)"failed to parse sanitization keywords");
    }

    private void handleW3CExternalTraceIdConfigurations() {
        if (!this.apmConfigurationProvider.isW3CNetworkExternalTraceIdEnabled()) {
            this.apmImplementation.clearW3CNetworkExternalTraceIdCache();
        } else {
            boolean bl = this.apmConfigurationProvider.isAttachingCapturedW3CExternalTraceIdFeatureAvailable();
            if (!this.apmConfigurationProvider.isAttachingGeneratedW3CExternalTraceIdFeatureAvailable()) {
                this.apmImplementation.clearGeneratedW3CExternalTraceIdCache();
            }
            if (!bl) {
                this.apmImplementation.clearCapturedW3CExternalTraceIdCache();
            }
        }
    }

    private void clearNetworkLogCache() {
        this.apmImplementation.clearNetworkCache();
    }

    private void clearGraphQlCache() {
        this.apmImplementation.clearGraphQlCache();
    }

    private void clearGrpcCache() {
        this.apmImplementation.clearGrpcCache();
    }

    private void resetNetworkConfiguration() {
        APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = networkInterceptionConfigurationProvider;
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setNetworkEnabled(false);
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setNetworkLogsLimitPerRequest(200L);
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setNetworkLogsStoreLimit(1000L);
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setNetworkLogsStoreAttributesLimit(5);
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setNetworkGraphQlFeatureEnabled(false);
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setNetworkGrpcInterceptionFeatureEnabled(false);
        NetworkInterceptionConfigurationProvider networkInterceptionConfigurationProvider = aPMConfigurationHandlerImpl.networkConfigurationProvider;
        if (networkInterceptionConfigurationProvider != null) {
            networkInterceptionConfigurationProvider.reset();
        }
    }

    private void handleExperimentsConfigurations(JSONObject jSONObject) {
        boolean bl = false;
        JSONObject jSONObject2 = jSONObject.optJSONObject("experiments");
        if (jSONObject2 != null) {
            bl = jSONObject2.optBoolean("enabled", false);
            this.apmConfigurationProvider.setExperimentsFeatureEnabled(bl);
            if (bl) {
                int n = jSONObject2.optInt("limit_per_request", 1000);
                this.apmConfigurationProvider.setExperimentsLimitPerRequest(n);
            } else {
                this.apmConfigurationProvider.resetExperimentsLimitPerRequest();
            }
        } else {
            this.resetExperimentsConfigurations();
        }
        if (!bl) {
            this.clearExperiments();
        }
    }

    private void handleFragmentSpansConfiguration(JSONObject jSONObject) {
        boolean bl = false;
        JSONObject jSONObject2 = jSONObject.optJSONObject("fragments");
        if (jSONObject2 != null) {
            bl = jSONObject2.optBoolean("enabled", false);
            this.apmConfigurationProvider.setFragmentSpansFeatureEnabledFlag(bl);
            int n = jSONObject2.optInt("store_limit", 1000);
            this.apmConfigurationProvider.setFragmentSpansStoreLimit(n);
            n = jSONObject2.optInt("limit_per_request", 200);
            this.apmConfigurationProvider.setFragmentSpansLimitPerRequest(n);
        } else {
            this.resetFragmentSpansConfiguration();
        }
        if (!bl) {
            APMConfigurationHandlerImpl.onFragmentSpansFeatureDisabled();
        }
    }

    private static void onFragmentSpansFeatureDisabled() {
        ServiceLocator.getFragmentSpansHelper().onFeatureDisabled();
    }

    private void resetFragmentSpansConfiguration() {
        APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = this;
        aPMConfigurationHandlerImpl.apmConfigurationProvider.resetFragmentSpansFeatureEnabledFlag();
        aPMConfigurationHandlerImpl.apmConfigurationProvider.resetFragmentSpansStoreLimit();
        aPMConfigurationHandlerImpl.apmConfigurationProvider.resetFragmentSpansLimitPerRequest();
    }

    private void resetExperimentsConfigurations() {
        APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = this;
        aPMConfigurationHandlerImpl.apmConfigurationProvider.resetExperimentsFeatureEnabledFlag();
        aPMConfigurationHandlerImpl.apmConfigurationProvider.resetExperimentsLimitPerRequest();
    }

    private void clearExperiments() {
        ExperimentHandler experimentHandler = ServiceLocator.getExperimentHandler();
        if (experimentHandler != null) {
            experimentHandler.clearAllExperimentsAsync();
        }
    }

    private void clearApmState() {
        APMStateProvider aPMStateProvider = ServiceLocator.getApmStateProvider();
        if (aPMStateProvider != null) {
            aPMStateProvider.clearState();
        }
    }

    private void resetConfiguration(ConfigurationHandler[] configurationHandlerArray) {
        APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = this;
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setAPMFeatureAvailability(false);
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setCrashDetectionEnabled(false);
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setDebugModeEnabled(false);
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setSyncInterval(21600L);
        aPMConfigurationHandlerImpl.apmConfigurationProvider.resetSessionStoreLimitEnabledFlag();
        aPMConfigurationHandlerImpl.apmConfigurationProvider.resetSessionStoreLimit();
        aPMConfigurationHandlerImpl.resetNetworkConfiguration();
        aPMConfigurationHandlerImpl.clearNetworkLogCache();
        aPMConfigurationHandlerImpl.resetUiTraceConfiguration();
        aPMConfigurationHandlerImpl.resetExecutionTraceConfiguration();
        aPMConfigurationHandlerImpl.clearExecutionTraceCache();
        aPMConfigurationHandlerImpl.resetColdAppLaunchesConfiguration();
        aPMConfigurationHandlerImpl.resetHotAppLaunchesConfiguration();
        aPMConfigurationHandlerImpl.resetWarmAppLaunchesConfiguration();
        aPMConfigurationHandlerImpl.clearAppLaunchesCache();
        aPMConfigurationHandlerImpl.resetExperimentsConfigurations();
        aPMConfigurationHandlerImpl.resetFragmentSpansConfiguration();
        aPMConfigurationHandlerImpl.clearExperiments();
        aPMConfigurationHandlerImpl.clearApmState();
        APMConfigurationHandlerImpl.onFragmentSpansFeatureDisabled();
        APMConfigurationHandlerImpl.resetConfigurationHandlers(configurationHandlerArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleConfiguration(@Nullable String string) {
        ConfigurationHandler[] configurationHandlerArray;
        boolean bl;
        block9: {
            bl = false;
            Object object = this.sdkConfigurationHandlersProvider.invoke();
            configurationHandlerArray = this.apmConfigurationHandlersProvider.invoke();
            if (string != null) {
                JSONException jSONException22;
                Object object2;
                block8: {
                    block7: {
                        block6: {
                            JSONObject jSONObject;
                            object2 = jSONObject;
                            try {
                                string = new JSONObject(string).optJSONObject("apm");
                            }
                            catch (JSONException jSONException22) {
                                break block8;
                            }
                            this.apmConfigurationProvider.setSendLegacyAPMSessions(object2.optBoolean("send_legacy_apm_session"));
                            if (string == null) break block6;
                            String string2 = string;
                            this.apmConfigurationProvider.setAPMFeatureAvailability(string2.optBoolean("enabled", false));
                            this.apmConfigurationProvider.setCrashDetectionEnabled(string2.optBoolean("crash_detection_enabled", false));
                            this.apmConfigurationProvider.setDebugModeEnabled(string2.optBoolean("debug_mode_enabled", false));
                            long l = string2.optLong("sync_interval", 21600L);
                            this.apmConfigurationProvider.setSyncInterval(l);
                            this.apmConfigurationProvider.setSessionStoreLimitEnabled(string2.optBoolean("session_store_limit_enabled", false));
                            this.apmConfigurationProvider.setSessionStoreLimit(string2.optInt("session_store_limit", 300));
                            this.invokeConfigurationHandlers((JSONObject)string, configurationHandlerArray);
                            this.handleAppLaunchConfigurations((JSONObject)string);
                            this.handleExecutionTracesConfiguration((JSONObject)string);
                            this.handleNetworkConfiguration((JSONObject)string, (JSONObject)object2);
                            this.handleUiTraceConfiguration((JSONObject)string);
                            this.handleExperimentsConfigurations((JSONObject)string);
                            this.handleFragmentSpansConfiguration((JSONObject)string);
                            break block7;
                        }
                        this.apmLogger.logSDKProtected("Can't parse APM configurations, object is null.");
                    }
                    this.invokeConfigurationHandlers((JSONObject)object2, (ConfigurationHandler[])object);
                    bl = true;
                    break block9;
                }
                object = this.apmLogger;
                object2 = jSONException22.getMessage() != null ? jSONException22.getMessage() : "";
                ((Logger)object).logSDKError((String)object2, jSONException22);
            }
        }
        if (this.apmConfigurationProvider.isAPMFeatureAvailable()) {
            this.apmLogger.logSDKProtected("APM feature configs: \nEnabled: " + this.apmConfigurationProvider.isAPMFeatureAvailable() + "\nTraces Enabled: " + this.apmConfigurationProvider.isExecutionTraceFeatureEnabled() + "\nCold App Launches Enabled: " + this.apmConfigurationProvider.isColdAppLaunchesFeatureEnabled() + "\nHot App Launches Enabled: " + this.apmConfigurationProvider.isHotAppLaunchesFeatureEnabled() + "\nNetwork Logs Enabled: " + this.apmConfigurationProvider.isNetworkFeatureEnabled() + "\nUI Traces Enabled: " + this.apmConfigurationProvider.isUiHangsFeatureEnabled() + "\nFragment spans Enabled: " + this.apmConfigurationProvider.isFragmentSpansFeatureEnabled());
            return bl;
        }
        this.apmLogger.logSDKProtected("APM feature configs: \nEnabled: false");
        this.resetConfiguration(configurationHandlerArray);
        return bl;
    }

    public void clearAppLaunchesCache(@NonNull String string) {
        this.apmImplementation.clearAppLaunchesCache(string);
    }

    public void clearAppLaunchesCache() {
        this.apmImplementation.clearAppLaunchesCache();
    }

    public void clearExecutionTraceCache() {
        this.apmImplementation.clearExecutionTracesCache();
    }

    public void resetExecutionTraceConfiguration() {
        APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = this;
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setExecutionTraceFeatureEnabled(false);
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setExecutionTraceLimitPerRequest(200L);
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setExecutionTraceStoreLimit(1000L);
        aPMConfigurationHandlerImpl.apmConfigurationProvider.setExecutionTraceStoreAttributesLimit(5);
    }

    @VisibleForTesting
    protected void handleUiTraceConfiguration(JSONObject jSONObject) {
        JSONObject jSONObject2 = null;
        if (jSONObject != null) {
            jSONObject2 = jSONObject.optJSONObject("ui");
        }
        if (jSONObject2 != null) {
            boolean bl = jSONObject2.optBoolean("enabled", false);
            APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = this;
            boolean bl2 = aPMConfigurationHandlerImpl.handleUiLoadingConfiguration(jSONObject2.optJSONObject("screen_loading"));
            aPMConfigurationHandlerImpl.apmConfigurationProvider.setUiHangsFeatureEnabled(bl);
            if (!bl && !bl2) {
                this.resetUiTraceConfiguration();
            } else {
                float f = (float)jSONObject2.optDouble("small_drop_duration_mus", 16700.0);
                this.apmConfigurationProvider.setUiTraceSmallDropThreshold(f);
                f = (float)jSONObject2.optDouble("large_drop_duration_mus", 250000.0);
                this.apmConfigurationProvider.setUiTraceLargeDropThreshold(f);
                long l = jSONObject2.optLong("limit_per_request", 200L);
                this.apmConfigurationProvider.setUiTraceLimitPerRequest(l);
                l = jSONObject2.optLong("store_limit", 1000L);
                this.apmConfigurationProvider.setUiTraceStoreLimit(l);
            }
        } else {
            APMConfigurationHandlerImpl aPMConfigurationHandlerImpl = this;
            aPMConfigurationHandlerImpl.apmLogger.logSDKProtected("Can't parse ui traces configurations, object is null.");
            aPMConfigurationHandlerImpl.resetUiTraceConfiguration();
        }
    }
}

