/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.cache.handler.uitrace;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.apm.cache.handler.uitrace.UiLoadingMetricCacheHandler;
import com.instabug.apm.cache.model.UiLoadingModel;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.library.internal.storage.cache.db.DatabaseManager;
import com.instabug.library.internal.storage.cache.db.SQLiteDatabaseWrapper;
import java.util.HashMap;
import java.util.Map;

public class UiLoadingMetricCacheHandlerImpl
implements UiLoadingMetricCacheHandler {
    private final Logger apmLogger = ServiceLocator.getApmLogger();

    private ContentValues getUiLoadingMetricModelContentValues(UiLoadingModel uiLoadingModel, long l) {
        ContentValues contentValues;
        UiLoadingMetricCacheHandlerImpl uiLoadingMetricCacheHandlerImpl = contentValues;
        uiLoadingMetricCacheHandlerImpl();
        uiLoadingMetricCacheHandlerImpl.put("ui_trace_id", l);
        uiLoadingMetricCacheHandlerImpl.put("duration_micro", uiLoadingModel.getDurationInMicro());
        uiLoadingMetricCacheHandlerImpl.put("start_timestamp", uiLoadingModel.getStartTimeStampMicro());
        contentValues.put("type", uiLoadingModel.getType());
        return contentValues;
    }

    private void insertStages(SQLiteDatabaseWrapper sQLiteDatabaseWrapper, Map<String, Long> object, long l) {
        if (sQLiteDatabaseWrapper != null && object != null) {
            for (Map.Entry entry : object.entrySet()) {
                ContentValues entry2 = this.getStagesContentValues((String)entry.getKey(), (Long)entry.getValue(), l);
                sQLiteDatabaseWrapper.insert("apm_ui_loading_stages", null, entry2);
            }
            return;
        }
    }

    private ContentValues getStagesContentValues(String string, Long l, long l2) {
        ContentValues contentValues;
        UiLoadingMetricCacheHandlerImpl uiLoadingMetricCacheHandlerImpl = contentValues;
        uiLoadingMetricCacheHandlerImpl();
        contentValues.put("ui_loading_metric_id", Long.valueOf(l2));
        contentValues.put("stage", string);
        contentValues.put("duration", l);
        return contentValues;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private UiLoadingModel getUiLoadingModelFromDatabase(long l) {
        UiLoadingModel uiLoadingModel = null;
        DatabaseManager databaseManager = this.getDatabaseManager();
        if (databaseManager == null) return uiLoadingModel;
        databaseManager = databaseManager.openDatabase();
        String string = String.valueOf(l);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = string;
        string = null;
        try {
            String string2 = "apm_ui_loading";
            String string3 = "ui_trace_id = ?";
            string = databaseManager.query(string2, null, string3, stringArray2, null, null, null);
            if (string != null) {
                return this.readUiLoadingModelFromCursor((Cursor)string);
            }
        }
        catch (Throwable throwable) {}
        catch (Exception exception) {}
        if (string != null) {
            string.close();
        }
        databaseManager.close();
        return uiLoadingModel;
    }

    @SuppressLint(value={"Range"})
    @Nullable
    private UiLoadingModel readUiLoadingModelFromCursor(@NonNull Cursor cursor) {
        if (cursor == null) {
            return null;
        }
        Object object = null;
        if (cursor.moveToFirst()) {
            UiLoadingModel uiLoadingModel;
            object = uiLoadingModel;
            Cursor cursor2 = cursor;
            Cursor cursor3 = cursor;
            Cursor cursor4 = cursor;
            Cursor cursor5 = cursor;
            ((UiLoadingModel)object)();
            ((UiLoadingModel)object).setId(cursor5.getLong(cursor5.getColumnIndex("id")));
            ((UiLoadingModel)object).setDurationInMicro(cursor4.getLong(cursor4.getColumnIndex("duration_micro")));
            ((UiLoadingModel)object).setStartTimeStampMicro(cursor3.getLong(cursor3.getColumnIndex("start_timestamp")));
            uiLoadingModel.setType(cursor2.getString(cursor2.getColumnIndex("type")));
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private Map<String, Long> getStagesForUiModel(long l) {
        Map<String, Long> map = null;
        DatabaseManager databaseManager = this.getDatabaseManager();
        if (databaseManager == null) return map;
        databaseManager = databaseManager.openDatabase();
        String string = String.valueOf(l);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = string;
        string = null;
        try {
            String string2 = "apm_ui_loading_stages";
            String string3 = "ui_loading_metric_id = ?";
            string = databaseManager.query(string2, null, string3, stringArray2, null, null, null);
            if (string != null) {
                return this.readStagesFromCursor((Cursor)string);
            }
        }
        catch (Throwable throwable) {}
        catch (Exception exception) {}
        if (string != null) {
            string.close();
        }
        databaseManager.close();
        return map;
    }

    @Nullable
    private Map<String, Long> readStagesFromCursor(@NonNull Cursor cursor) {
        HashMap hashMap;
        if (cursor == null) {
            return null;
        }
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        while (cursor.moveToNext()) {
            Cursor cursor2 = cursor;
            String string = cursor2.getString(cursor2.getColumnIndex("stage"));
            hashMap2.put(string, cursor2.getLong(cursor2.getColumnIndex("duration")));
        }
        if (hashMap2.isEmpty()) {
            return null;
        }
        return hashMap2;
    }

    @Nullable
    private DatabaseManager getDatabaseManager() {
        return ServiceLocator.getDatabaseManager();
    }

    @Override
    public long insert(UiLoadingModel uiLoadingModel, long l) {
        long l2;
        block9: {
            if (uiLoadingModel == null) {
                return -1L;
            }
            l2 = -1L;
            DatabaseManager databaseManager = this.getDatabaseManager();
            if (databaseManager != null) {
                Throwable throwable2;
                SQLiteDatabaseWrapper sQLiteDatabaseWrapper;
                block8: {
                    long l3;
                    block7: {
                        UiLoadingModel uiLoadingModel2 = uiLoadingModel;
                        sQLiteDatabaseWrapper = databaseManager.openDatabase();
                        uiLoadingModel = this.getUiLoadingMetricModelContentValues(uiLoadingModel, l);
                        try {
                            l3 = sQLiteDatabaseWrapper.insert("apm_ui_loading", null, (ContentValues)uiLoadingModel);
                        }
                        catch (Throwable throwable2) {
                            break block8;
                        }
                        Map<String, Long> map = uiLoadingModel2.getStages();
                        if (map == null) break block7;
                        if (map.isEmpty() || l3 == -1L) break block7;
                        this.insertStages(sQLiteDatabaseWrapper, map, l3);
                    }
                    sQLiteDatabaseWrapper.close();
                    l2 = l3;
                    break block9;
                }
                sQLiteDatabaseWrapper.close();
                throw throwable2;
            }
        }
        return l2;
    }

    @Override
    @Nullable
    public UiLoadingModel getUiLoadingMetricForUiTrace(long l) {
        UiLoadingModel uiLoadingModel = this.getUiLoadingModelFromDatabase(l);
        if (uiLoadingModel != null) {
            uiLoadingModel.setStages(this.getStagesForUiModel(uiLoadingModel.getId()));
        }
        return uiLoadingModel;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeAll() {
        Throwable throwable2;
        DatabaseManager databaseManager;
        block4: {
            databaseManager = this.getDatabaseManager();
            if (databaseManager == null) return;
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = databaseManager.openDatabase();
            databaseManager = sQLiteDatabaseWrapper;
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper2 = databaseManager;
            sQLiteDatabaseWrapper.execSQL("DELETE FROM apm_ui_loading");
            {
                catch (Throwable throwable2) {
                    break block4;
                }
                catch (Exception exception) {}
                {
                    sQLiteDatabaseWrapper2 = databaseManager;
                    this.apmLogger.logSDKError("DB execution a sql failed: " + exception.getMessage(), exception);
                }
            }
            sQLiteDatabaseWrapper2.close();
            return;
        }
        databaseManager.close();
        throw throwable2;
    }
}

