/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.cache.handler.session;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.apm.cache.handler.session.SessionCacheHandler;
import com.instabug.apm.cache.model.SessionCacheModel;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.storage.cache.db.DatabaseManager;
import com.instabug.library.internal.storage.cache.db.SQLiteDatabaseWrapper;
import com.instabug.library.internal.utils.stability.execution.ReturnableExecutable;
import com.instabug.library.internal.utils.stability.handler.exception.ExceptionHandler;
import com.instabug.library.model.common.Session;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.Collections;
import java.util.List;

public class SessionCacheHandlerImpl
implements SessionCacheHandler {
    @NonNull
    private final ExceptionHandler exceptionHandler;
    @NonNull
    private final Logger logger;

    public SessionCacheHandlerImpl(@NonNull ExceptionHandler exceptionHandler, @NonNull Logger logger2) {
        this.exceptionHandler = exceptionHandler;
        this.logger = logger2;
    }

    private String prepareArgs(int n) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append("(");
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append("?");
            if (i >= n - 1) continue;
            stringBuilder2.append(",");
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append(")");
        return stringBuilder3.toString();
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private ContentValues map(Session session) {
        ContentValues contentValues;
        SessionCacheHandlerImpl sessionCacheHandlerImpl = contentValues;
        sessionCacheHandlerImpl();
        sessionCacheHandlerImpl.put("core_session_id", session.getId());
        sessionCacheHandlerImpl.put("os", session.getOs());
        sessionCacheHandlerImpl.put("uuid", session.getUuid());
        sessionCacheHandlerImpl.put("core_session_version", session.getVersion());
        sessionCacheHandlerImpl.put("app_version", session.getAppVersion());
        contentValues.put("started_at", Long.valueOf(session.getStartTimestampMicros()));
        return contentValues;
    }

    private ContentValues map(@NonNull SessionCacheModel sessionCacheModel) {
        ContentValues contentValues;
        SessionCacheHandlerImpl sessionCacheHandlerImpl = contentValues;
        sessionCacheHandlerImpl();
        sessionCacheHandlerImpl.put("session_id", sessionCacheModel.getId());
        sessionCacheHandlerImpl.put("core_session_id", sessionCacheModel.getCoreId());
        sessionCacheHandlerImpl.put("os", sessionCacheModel.getOs());
        sessionCacheHandlerImpl.put("uuid", sessionCacheModel.getUuid());
        sessionCacheHandlerImpl.put("app_version", sessionCacheModel.getAppVersion());
        sessionCacheHandlerImpl.put("started_at", sessionCacheModel.getStartTimestampMicros());
        sessionCacheHandlerImpl.put("duration", sessionCacheModel.getDuration());
        sessionCacheHandlerImpl.put("core_session_version", sessionCacheModel.getVersion());
        contentValues.put("termination_code", Integer.valueOf(sessionCacheModel.getTerminationStatusCode()));
        return contentValues;
    }

    private SessionCacheModel map(@NonNull Cursor object) {
        Cursor cursor = object;
        int n = cursor.getColumnIndex("session_id");
        int n2 = cursor.getColumnIndex("core_session_id");
        int n3 = cursor.getColumnIndex("core_session_version");
        int n4 = cursor.getColumnIndex("os");
        int n5 = cursor.getColumnIndex("app_version");
        int n6 = cursor.getColumnIndex("uuid");
        int n7 = cursor.getColumnIndex("duration");
        int n8 = cursor.getColumnIndex("started_at");
        int n9 = cursor.getColumnIndex("termination_code");
        int n10 = cursor.getColumnIndex("sync_status");
        Cursor cursor2 = object;
        String string = cursor2.getString(n);
        object = cursor2.getString(n2);
        String string2 = cursor2.getString(n4);
        String string3 = cursor2.getString(n5);
        String string4 = cursor2.getString(n6);
        long l = cursor2.getLong(n7);
        long l2 = cursor2.getLong(n8);
        String string5 = cursor2.getString(n3);
        n8 = cursor2.getInt(n9);
        n9 = cursor2.getInt(n10);
        return new SessionCacheModel(string, (String)object, string2, string3, string4, l, l2, 0L, string5, n8, n9);
    }

    @Override
    @Nullable
    public SessionCacheModel insert(@NonNull Session session) {
        return (SessionCacheModel)this.exceptionHandler.executeAndGet(() -> {
            DatabaseManager databaseManager = ServiceLocator.getDatabaseManager();
            if (databaseManager != null) {
                long l;
                SessionCacheHandlerImpl sessionCacheHandlerImpl = sessionCacheHandlerImpl.map(session);
                databaseManager = databaseManager.openDatabase();
                try {
                    l = databaseManager.insertWithOnConflict("apm_session_table", null, (ContentValues)sessionCacheHandlerImpl);
                }
                catch (Throwable throwable) {
                    databaseManager.close();
                    throw throwable;
                }
                SessionCacheModel sessionCacheModel = new SessionCacheModel(String.valueOf(l), session);
                databaseManager.close();
                return sessionCacheModel;
            }
            return null;
        });
    }

    @Override
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public int update(final @NonNull SessionCacheModel sessionCacheModel) {
        return (Integer)this.exceptionHandler.executeAndGet((ReturnableExecutable)new ReturnableExecutable<Integer>(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Integer execute() {
                Integer n;
                String[] stringArray;
                String string;
                String string2;
                DatabaseManager databaseManager = ServiceLocator.getDatabaseManager();
                if (databaseManager == null) return 0;
                DatabaseManager databaseManager2 = databaseManager;
                databaseManager = SessionCacheHandlerImpl.this.map(sessionCacheModel);
                SQLiteDatabaseWrapper sQLiteDatabaseWrapper = databaseManager2.openDatabase();
                try {
                    string2 = "session_id = ?";
                    string = sessionCacheModel.getId();
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                }
                catch (Exception exception) {
                    try {}
                    catch (Throwable throwable) {}
                    SessionCacheHandlerImpl.this.logger.logSDKError("DB execution a sql failed: " + exception.getMessage(), exception);
                    IBGDiagnostics.reportNonFatal((Throwable)exception, (String)("Error while updating session: " + exception.getMessage()));
                    sQLiteDatabaseWrapper.close();
                }
                {
                    stringArray2[0] = string;
                    n = sQLiteDatabaseWrapper.update("apm_session_table", (ContentValues)databaseManager, string2, stringArray);
                }
                sQLiteDatabaseWrapper.close();
                return n;
                finally {
                    return 0;
                }
            }
        }, (Object)0);
    }

    @Override
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public int updateEndReason(final @NonNull String string, final long l, final int n) {
        return (Integer)this.exceptionHandler.executeAndGet((ReturnableExecutable)new ReturnableExecutable<Integer>(){

            public Integer execute() {
                DatabaseManager databaseManager = ServiceLocator.getDatabaseManager();
                if (databaseManager != null) {
                    ContentValues contentValues;
                    DatabaseManager databaseManager2 = databaseManager;
                    databaseManager = contentValues;
                    databaseManager();
                    databaseManager.put("termination_code", Integer.valueOf(string3.n));
                    contentValues.put("duration", Long.valueOf(string3.l));
                    SQLiteDatabaseWrapper sQLiteDatabaseWrapper = databaseManager2.openDatabase();
                    2 v2 = string3;
                    String string3 = "core_session_id = ?";
                    String string2 = v2.string;
                    String[] stringArray = new String[1];
                    String[] stringArray2 = stringArray;
                    try {
                        stringArray[0] = string2;
                        return sQLiteDatabaseWrapper.update("apm_session_table", (ContentValues)databaseManager, string3, stringArray2);
                    }
                    finally {
                        sQLiteDatabaseWrapper.close();
                    }
                }
                return 0;
            }
        }, (Object)0);
    }

    @Override
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public int trimSessions(int n) {
        return (Integer)this.exceptionHandler.executeAndGet(() -> {
            DatabaseManager databaseManager = ServiceLocator.getDatabaseManager();
            if (databaseManager != null) {
                String string = "session_id NOT IN (" + ("SELECT session_id FROM apm_session_table ORDER BY session_id DESC LIMIT " + n) + ")";
                return databaseManager.openDatabase().delete("apm_session_table", string, null);
            }
            return 0;
        }, (Object)0);
    }

    @Override
    @NonNull
    public List<SessionCacheModel> queryByCoreIds(@NonNull List<String> list) {
        return (List)this.exceptionHandler.executeAndGet(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 9[TRYBLOCK] [9 : 137->144)] java.lang.Exception
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, Collections.emptyList());
    }

    @Override
    public void deleteByCoreIds(@NonNull List<String> list) {
        this.exceptionHandler.execute(() -> {
            Object object = ServiceLocator.getDatabaseManager();
            if (object != null) {
                SQLiteDatabaseWrapper sQLiteDatabaseWrapper = object.openDatabase();
                List list2 = list;
                object = "core_session_id IN " + this.prepareArgs(list.size());
                String[] stringArray = list2.toArray(new String[0]);
                int n = sQLiteDatabaseWrapper.delete("apm_session_table", (String)object, stringArray);
                try {
                    this.logger.logSDKProtected("Deleted " + n + " row/s associated with session IDs: " + String.join((CharSequence)",", list));
                }
                catch (Exception exception) {
                    this.logger.logSDKError("Error while deleting sessions: " + exception.getMessage(), exception);
                    IBGDiagnostics.reportNonFatal((Throwable)exception, (String)("Error while deleting sessions: " + exception.getMessage()));
                }
            }
        });
    }

    /*
     * Exception decompiling
     */
    @Override
    @NonNull
    public List<SessionCacheModel> getReadyToBeSentSessions() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [9, 8 : 114->120)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    public SessionCacheModel getNextSession(String var1_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [11, 10 : 111->117)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void changeSessionSyncStatus(@NonNull List<String> contentValues, int n) {
        SessionCacheHandlerImpl sessionCacheHandlerImpl = ServiceLocator.getDatabaseManager();
        if (sessionCacheHandlerImpl != null) {
            ContentValues contentValues2;
            ContentValues contentValues3 = contentValues;
            sessionCacheHandlerImpl = sessionCacheHandlerImpl.openDatabase();
            contentValues = contentValues2;
            contentValues();
            contentValues2.put("sync_status", Integer.valueOf(n));
            for (String string : contentValues3) {
                String[] stringArray = new String[1];
                String[] stringArray2 = stringArray;
                stringArray[0] = string;
                sessionCacheHandlerImpl.update("apm_session_table", contentValues, "session_id in (?)", stringArray2);
            }
            sessionCacheHandlerImpl.close();
        }
    }

    @Override
    public void deleteSessionsBySyncStatus(int n) {
        Object object = ServiceLocator.getDatabaseManager();
        if (object != null) {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = object.openDatabase();
            object = String.valueOf(n);
            String[] stringArray = new String[1];
            String[] stringArray2 = stringArray;
            stringArray[0] = object;
            sQLiteDatabaseWrapper.delete("apm_session_table", "sync_status = ?", stringArray2);
            sQLiteDatabaseWrapper.close();
        }
    }

    @Override
    @Nullable
    public SessionCacheModel getPreviousSession(final String string) {
        return (SessionCacheModel)this.exceptionHandler.executeAndGet((ReturnableExecutable)new ReturnableExecutable<SessionCacheModel>(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            public SessionCacheModel execute() {
                Throwable throwable2;
                Cursor cursor;
                DatabaseManager databaseManager;
                block9: {
                    SessionCacheModel sessionCacheModel;
                    block10: {
                        Exception exception2;
                        block8: {
                            SessionCacheModel sessionCacheModel2;
                            databaseManager = ServiceLocator.getDatabaseManager();
                            if (databaseManager == null) {
                                return null;
                            }
                            databaseManager = databaseManager.openDatabase();
                            cursor = null;
                            try {
                                cursor = databaseManager.rawQuery("SELECT * FROM apm_session_table where session_id < " + this_.string + " ORDER BY " + "started_at" + " DESC LIMIT 1", null);
                                if (cursor == null || !cursor.moveToFirst()) break block8;
                                sessionCacheModel2 = this_.SessionCacheHandlerImpl.this.map(cursor);
                            }
                            catch (Throwable throwable2) {
                                break block9;
                            }
                            catch (Exception exception2) {}
                            cursor.close();
                            databaseManager.close();
                            return sessionCacheModel2;
                        }
                        6 this_ = null;
                        if (cursor != null) {
                            cursor.close();
                        }
                        databaseManager.close();
                        return this_;
                        {
                            InstabugSDKLogger.e((String)"IBG-APM", (String)("Error while getting previous session from DB: " + exception2.getMessage()), (Throwable)exception2);
                            IBGDiagnostics.reportNonFatal((Throwable)exception2, (String)("Error while getting previous session from DB: " + exception2.getMessage()));
                            sessionCacheModel = null;
                            if (cursor == null) break block10;
                        }
                        cursor.close();
                    }
                    databaseManager.close();
                    return sessionCacheModel;
                }
                if (cursor != null) {
                    cursor.close();
                }
                databaseManager.close();
                throw throwable2;
            }
        });
    }
}

