/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.cache.handler.experiment;

import android.content.ContentValues;
import android.database.Cursor;
import com.instabug.apm.cache.handler.experiment.ExperimentCacheHandler;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.storage.cache.db.DatabaseManager;
import com.instabug.library.internal.storage.cache.db.SQLiteDatabaseWrapper;
import com.instabug.library.map.TwoWayMapper;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\u00020\u00132\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000f\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/instabug/apm/cache/handler/experiment/ExperimentCacheHandlerImpl;", "Lcom/instabug/apm/cache/handler/experiment/ExperimentCacheHandler;", "databaseManager", "Lcom/instabug/library/internal/storage/cache/db/DatabaseManager;", "logger", "Lcom/instabug/apm/logger/internal/Logger;", "mapper", "Lcom/instabug/library/map/TwoWayMapper;", "", "", "", "(Lcom/instabug/library/internal/storage/cache/db/DatabaseManager;Lcom/instabug/apm/logger/internal/Logger;Lcom/instabug/library/map/TwoWayMapper;)V", "addExperiments", "", "experiments", "sessionId", "clear", "", "getContentValue", "Landroid/content/ContentValues;", "getExperiments", "cursor", "Landroid/database/Cursor;", "instabug-apm_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nExperimentCacheHandlerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExperimentCacheHandlerImpl.kt\ncom/instabug/apm/cache/handler/experiment/ExperimentCacheHandlerImpl\n+ 2 CursorUtilis.kt\ncom/instabug/library/CursorUtilisKt\n*L\n1#1,83:1\n6#2,5:84\n*S KotlinDebug\n*F\n+ 1 ExperimentCacheHandlerImpl.kt\ncom/instabug/apm/cache/handler/experiment/ExperimentCacheHandlerImpl\n*L\n73#1:84,5\n*E\n"})
public final class ExperimentCacheHandlerImpl
implements ExperimentCacheHandler {
    @NotNull
    private final DatabaseManager databaseManager;
    @NotNull
    private final Logger logger;
    @NotNull
    private final TwoWayMapper<List<String>, byte[]> mapper;

    public ExperimentCacheHandlerImpl(@NotNull DatabaseManager databaseManager, @NotNull Logger logger2, @NotNull TwoWayMapper<List<String>, byte[]> twoWayMapper) {
        Intrinsics.checkNotNullParameter((Object)databaseManager, (String)"databaseManager");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter(twoWayMapper, (String)"mapper");
        this.databaseManager = databaseManager;
        this.logger = logger2;
        this.mapper = twoWayMapper;
    }

    private final ContentValues getContentValue(List<String> list, String string) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("session_id", string);
        contentValues.put("experiment_array", (byte[])this.mapper.mapForwards(list));
        return contentValues;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final List<String> getExperiments(Cursor cursor) {
        Throwable throwable2;
        block4: {
            try {
                List list;
                Object object;
                if (cursor.moveToFirst()) {
                    ExperimentCacheHandlerImpl experimentCacheHandlerImpl = object;
                    Cursor cursor2 = cursor;
                    object = cursor2.getBlob(cursor2.getColumnIndex("experiment_array"));
                    TwoWayMapper<List<String>, byte[]> twoWayMapper = experimentCacheHandlerImpl.mapper;
                    Object object2 = object;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"experimentsByteArray");
                    list = (List)twoWayMapper.mapBackwards(object2);
                } else {
                    list = CollectionsKt.emptyList();
                }
                object = list;
            }
            catch (Throwable throwable2) {
                break block4;
            }
            cursor.close();
            return object;
        }
        cursor.close();
        throw throwable2;
    }

    @Override
    public long addExperiments(@NotNull List<String> contentValues, @NotNull String string) {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper;
        Intrinsics.checkNotNullParameter(contentValues, (String)"experiments");
        Intrinsics.checkNotNullParameter((Object)string, (String)"sessionId");
        try {
            sQLiteDatabaseWrapper = this.databaseManager.openDatabase();
            contentValues = this.getContentValue((List<String>)contentValues, string);
        }
        catch (Exception exception) {
            this.logger.logSDKError("DB execution a sql failed", exception);
            IBGDiagnostics.reportNonFatal((Throwable)exception, (String)"DB execution a sql failed");
            return -1L;
        }
        return sQLiteDatabaseWrapper.insertWithOnConflict("apm_experiment", null, contentValues);
    }

    @Override
    @NotNull
    public List<String> getExperiments(@NotNull String string) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)string, (String)"sessionId");
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.databaseManager.openDatabase();
            String string2 = "apm_experiment";
            String[] stringArray = new String[1];
            String[] stringArray2 = stringArray;
            stringArray[0] = "experiment_array";
            String string3 = "session_id = ?";
            String[] stringArray3 = new String[1];
            String[] stringArray4 = stringArray3;
            stringArray3[0] = string;
            string = sQLiteDatabaseWrapper.query(string2, stringArray2, string3, stringArray4, null, null, null);
            if (string == null) break block5;
            try {
                return this.getExperiments((Cursor)string);
            }
            catch (Exception exception) {
                this.logger.logSDKError("DB execution a sql failed", exception);
                IBGDiagnostics.reportNonFatal((Throwable)exception, (String)"DB execution a sql failed");
            }
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public void clear() {
        try {
            this.databaseManager.openDatabase().delete("apm_experiment", null, null);
        }
        catch (Exception exception) {
            this.logger.logSDKError("DB execution a sql failed", exception);
            IBGDiagnostics.reportNonFatal((Throwable)exception, (String)"DB execution a sql failed");
        }
    }
}

