/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.appflow.validate;

import com.instabug.apm.appflow.configuration.AppFlowConfigurationProvider;
import com.instabug.apm.appflow.log.LoggerExtKt;
import com.instabug.apm.appflow.validate.ConfigurationsValidator;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.sanitization.Validator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u000eH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/instabug/apm/appflow/validate/AppFlowAttributeConfigurationValidator;", "Lcom/instabug/apm/appflow/validate/ConfigurationsValidator;", "Lcom/instabug/apm/sanitization/Validator;", "", "apiName", "", "apmConfigurations", "Lcom/instabug/apm/configuration/APMConfigurationProvider;", "appFLowConfigurations", "Lcom/instabug/apm/appflow/configuration/AppFlowConfigurationProvider;", "logger", "Lcom/instabug/apm/logger/internal/Logger;", "(Ljava/lang/String;Lcom/instabug/apm/configuration/APMConfigurationProvider;Lcom/instabug/apm/appflow/configuration/AppFlowConfigurationProvider;Lcom/instabug/apm/logger/internal/Logger;)V", "isValid", "", "item", "(Lkotlin/Unit;)Z", "validateAttributeConfigurationsAndLogIfNot", "instabug-apm_defaultUiRelease"})
public final class AppFlowAttributeConfigurationValidator
extends ConfigurationsValidator
implements Validator<Unit> {
    public AppFlowAttributeConfigurationValidator(@NotNull String string, @NotNull APMConfigurationProvider aPMConfigurationProvider, @NotNull AppFlowConfigurationProvider appFlowConfigurationProvider, @NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"apiName");
        Intrinsics.checkNotNullParameter((Object)aPMConfigurationProvider, (String)"apmConfigurations");
        Intrinsics.checkNotNullParameter((Object)appFlowConfigurationProvider, (String)"appFLowConfigurations");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        super(string, aPMConfigurationProvider, appFlowConfigurationProvider, logger2);
    }

    private final boolean validateAttributeConfigurationsAndLogIfNot() {
        boolean bl = this.getAppFLowConfigurations().getAttributesEnabled();
        if (!bl) {
            LoggerExtKt.logFeatureBEDisabled(this.getLogger(), this.getApiName());
        }
        return bl;
    }

    @Override
    public boolean isValid(@NotNull Unit unit) {
        Unit unit2 = unit;
        Intrinsics.checkNotNullParameter((Object)unit2, (String)"item");
        return super.isValid(unit2) && this.validateAttributeConfigurationsAndLogIfNot();
    }
}

