/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.appflow.usecases;

import com.instabug.apm.appflow.configuration.AppFlowConfigurationProvider;
import com.instabug.apm.appflow.handler.AppFlowHandler;
import com.instabug.apm.appflow.log.LoggerExtKt;
import com.instabug.apm.appflow.model.AppFlowAttribute;
import com.instabug.apm.appflow.usecases.UseCase;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.model.TimeCaptureBoundModel;
import com.instabug.apm.sanitization.Sanitizer;
import com.instabug.apm.sanitization.Validator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0010\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001B]\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0001\u00a2\u0006\u0002\u0010\u0013J*\u0010\u0014\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J/\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u0017\u0010 \u001a\u00020\u00042\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0096\u0002J\u0018\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u001bH\u0002J\u0012\u0010%\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0002J\u0016\u0010&\u001a\u00020\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J\u001f\u0010'\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010(J/\u0010)\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/instabug/apm/appflow/usecases/SetFlowAttributeUseCase;", "Lcom/instabug/apm/appflow/usecases/UseCase;", "Lcom/instabug/apm/model/TimeCaptureBoundModel;", "Lcom/instabug/apm/appflow/model/AppFlowAttribute;", "", "handler", "Lcom/instabug/apm/appflow/handler/AppFlowHandler;", "logger", "Lcom/instabug/apm/logger/internal/Logger;", "configurationsValidator", "Lcom/instabug/apm/sanitization/Validator;", "attributeValidator", "attributeSanitizer", "Lcom/instabug/apm/sanitization/Sanitizer;", "appFlowConfigurations", "Lcom/instabug/apm/appflow/configuration/AppFlowConfigurationProvider;", "refreshBackgroundFlowUseCase", "", "", "(Lcom/instabug/apm/appflow/handler/AppFlowHandler;Lcom/instabug/apm/logger/internal/Logger;Lcom/instabug/apm/sanitization/Validator;Lcom/instabug/apm/sanitization/Validator;Lcom/instabug/apm/sanitization/Sanitizer;Lcom/instabug/apm/appflow/configuration/AppFlowConfigurationProvider;Lcom/instabug/apm/appflow/usecases/UseCase;)V", "addAttribute", "originalFlowName", "", "flowName", "key", "value", "addOrUpdateAttribute", "", "originalAttribute", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/instabug/apm/appflow/model/AppFlowAttribute;)Ljava/lang/Integer;", "handleAttribute", "sanitizedAttribute", "invoke", "param", "logAttributeMaxCountReached", "attribute", "attributesStoreLimit", "logNoMatchingActiveFlow", "passedAbandonmentThreshold", "removeAttribute", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Boolean;", "validateCountAndAddAttribute", "originalFlow", "instabug-apm_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nSetFlowAttributeUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetFlowAttributeUseCase.kt\ncom/instabug/apm/appflow/usecases/SetFlowAttributeUseCase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public final class SetFlowAttributeUseCase
implements UseCase<TimeCaptureBoundModel<AppFlowAttribute>, Unit> {
    @NotNull
    private final AppFlowHandler handler;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Validator<Unit> configurationsValidator;
    @NotNull
    private final Validator<AppFlowAttribute> attributeValidator;
    @NotNull
    private final Sanitizer<AppFlowAttribute> attributeSanitizer;
    @NotNull
    private final AppFlowConfigurationProvider appFlowConfigurations;
    @NotNull
    private final UseCase<Long, Boolean> refreshBackgroundFlowUseCase;

    public SetFlowAttributeUseCase(@NotNull AppFlowHandler appFlowHandler, @NotNull Logger logger2, @NotNull Validator<Unit> validator, @NotNull Validator<AppFlowAttribute> validator2, @NotNull Sanitizer<AppFlowAttribute> sanitizer, @NotNull AppFlowConfigurationProvider appFlowConfigurationProvider, @NotNull UseCase<Long, Boolean> useCase) {
        Intrinsics.checkNotNullParameter((Object)appFlowHandler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter(validator, (String)"configurationsValidator");
        Intrinsics.checkNotNullParameter(validator2, (String)"attributeValidator");
        Intrinsics.checkNotNullParameter(sanitizer, (String)"attributeSanitizer");
        Intrinsics.checkNotNullParameter((Object)appFlowConfigurationProvider, (String)"appFlowConfigurations");
        Intrinsics.checkNotNullParameter(useCase, (String)"refreshBackgroundFlowUseCase");
        this.handler = appFlowHandler;
        this.logger = logger2;
        this.configurationsValidator = validator;
        this.attributeValidator = validator2;
        this.attributeSanitizer = sanitizer;
        this.appFlowConfigurations = appFlowConfigurationProvider;
        this.refreshBackgroundFlowUseCase = useCase;
    }

    private final boolean passedAbandonmentThreshold(TimeCaptureBoundModel<AppFlowAttribute> timeCaptureBoundModel) {
        boolean bl = Intrinsics.areEqual((Object)this.refreshBackgroundFlowUseCase.invoke(timeCaptureBoundModel.getTimeCapture().getTimeStampMillis()), (Object)Boolean.TRUE);
        if (bl) {
            this.logNoMatchingActiveFlow(timeCaptureBoundModel.getModel().getName());
        }
        return bl;
    }

    private final void handleAttribute(AppFlowAttribute appFlowAttribute, AppFlowAttribute object) {
        String string;
        String string2 = ((AppFlowAttribute)object).getName();
        if (string2 != null && (string = ((AppFlowAttribute)object).getKey()) != null) {
            if ((object = ((AppFlowAttribute)object).getValue()) != null) {
                this.addOrUpdateAttribute(string2, string, (String)object, appFlowAttribute);
            } else {
                this.removeAttribute(string2, string);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Integer addOrUpdateAttribute(String string, String string2, String string3, AppFlowAttribute appFlowAttribute) {
        Boolean bl = this.handler.updateAttributeValue(string, string2, string3);
        if (bl == null) return null;
        if (bl != false) return null;
        if (bl == null) return null;
        Integer n = this.validateCountAndAddAttribute(string, string2, string3, appFlowAttribute);
        return n;
    }

    private final Integer validateCountAndAddAttribute(String string, String string2, String string3, AppFlowAttribute appFlowAttribute) {
        Integer n = this.handler.getAttributeCount(string);
        if (n != null) {
            int n2 = this.appFlowConfigurations.getAttributesStoreLimit();
            SetFlowAttributeUseCase setFlowAttributeUseCase = n < n2 ? this : null;
            if (setFlowAttributeUseCase != null) {
                this.addAttribute(appFlowAttribute.getName(), string, string2, string3);
            } else {
                this.logAttributeMaxCountReached(appFlowAttribute, n2);
            }
        } else {
            n = null;
        }
        return n;
    }

    private final void addAttribute(String string, String object, String string2, String string3) {
        if ((object = this.handler.addAttribute((String)object, string2, string3)) != null) {
            if (((Boolean)object).booleanValue()) {
                object = null;
            }
            if (object != null) {
                this.logNoMatchingActiveFlow(string);
            }
        }
    }

    private final void logNoMatchingActiveFlow(String string) {
        if (string != null) {
            LoggerExtKt.logAttributeWasNotAddedNoMatchingActiveFlow(this.logger, string);
        }
    }

    private final void logAttributeMaxCountReached(AppFlowAttribute appFlowAttribute, int n) {
        AppFlowAttribute appFlowAttribute2 = appFlowAttribute;
        String string = appFlowAttribute2.getName();
        LoggerExtKt.logAttributesExceededMaxAllowedCount(((SetFlowAttributeUseCase)((Object)string)).logger, string, appFlowAttribute2.getKey(), n);
    }

    private final Boolean removeAttribute(String string, String string2) {
        return this.handler.removeAttribute(string, string2);
    }

    @Override
    public void invoke(@NotNull TimeCaptureBoundModel<AppFlowAttribute> timeCaptureBoundModel) {
        Intrinsics.checkNotNullParameter(timeCaptureBoundModel, (String)"param");
        TimeCaptureBoundModel<AppFlowAttribute> timeCaptureBoundModel2 = this.configurationsValidator.isValid(Unit.INSTANCE) ? timeCaptureBoundModel : null;
        if (timeCaptureBoundModel2 != null) {
            if (!this.attributeValidator.isValid(timeCaptureBoundModel.getModel())) {
                timeCaptureBoundModel2 = null;
            }
            if (timeCaptureBoundModel2 != null && (timeCaptureBoundModel2 = this.attributeSanitizer.sanitize(timeCaptureBoundModel.getModel())) != null) {
                Pair pair;
                Pair pair2 = pair;
                pair = new Pair((Object)timeCaptureBoundModel.getModel(), (Object)timeCaptureBoundModel2);
                if (this.passedAbandonmentThreshold(timeCaptureBoundModel)) {
                    pair2 = null;
                }
                if (pair2 != null) {
                    this.handleAttribute((AppFlowAttribute)pair2.getFirst(), (AppFlowAttribute)pair2.getSecond());
                }
            }
        }
    }
}

