/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.appflow.log;

import com.instabug.apm.logger.internal.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\b\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a \u0010\u0005\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0000\u001a\u0016\u0010\b\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u0000\u001a \u0010\t\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0000\u001a \u0010\n\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0000\u001a\u0014\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0004H\u0000\u001a(\u0010\r\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0014\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u000fH\u0000\u001a\u0014\u0010\u0012\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\f\u0010\u0013\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0014\u0010\u0014\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0015\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0016\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0004H\u0000\u00a8\u0006\u0017"}, d2={"logAPMSdkDisabled", "", "Lcom/instabug/apm/logger/internal/Logger;", "apiName", "", "logAttributeKeyExceededMaxLength", "flowName", "key", "logAttributeKeyIsNullOrEmpty", "logAttributeValueExceededMaxLength", "logAttributeValueIsEmpty", "logAttributeWasNotAddedNoMatchingActiveFlow", "name", "logAttributesExceededMaxAllowedCount", "maxCount", "", "logDroppedFlows", "dropCount", "logFeatureBEDisabled", "logFlowNameIsNullOrEmpty", "logFlowNameTruncated", "logFlowNotEndedNoMatchingActiveFlow", "logForceAbandonedFlow", "instabug-apm_defaultUiRelease"})
public abstract class LoggerExtKt {
    public static final void logFeatureBEDisabled(@NotNull Logger logger2, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"apiName");
        logger2.e(StringsKt.replace$default((String)"%R wasn't called as the feature seems to be disabled for your Instabug company account. Please contact support for more information.", (String)"%R", (String)string, (boolean)false, (int)4, null));
    }

    public static final void logAPMSdkDisabled(@NotNull Logger logger2, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"apiName");
        logger2.e(StringsKt.replace$default((String)"%R wasn't called. Please make sure to enable APM first by following the instructions at this link: https://docs.instabug.com/reference#enable-or-disable-apm", (String)"%R", (String)string, (boolean)false, (int)4, null));
    }

    public static final void logForceAbandonedFlow(@NotNull Logger logger2, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"name");
        logger2.e(StringsKt.replace$default((String)"A flow with name %R already started, It will be abandoned and a new flow with the same name will be started.", (String)"%R", (String)string, (boolean)false, (int)4, null));
    }

    public static final void logFlowNotEndedNoMatchingActiveFlow(@NotNull Logger logger2, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"name");
        logger2.e(StringsKt.replace$default((String)"Can\u2019t end flow, No flow existing with name %R, please start the flow by calling startFlow first.", (String)"%R", (String)string, (boolean)false, (int)4, null));
    }

    public static final void logAttributeWasNotAddedNoMatchingActiveFlow(@NotNull Logger logger2, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"name");
        logger2.e(StringsKt.replace$default((String)"Can\u2019t set flow attribute, No flow existing with name %R, please start the flow by calling startFlow first.", (String)"%R", (String)string, (boolean)false, (int)4, null));
    }

    public static final void logFlowNameIsNullOrEmpty(@NotNull Logger logger2) {
        Logger logger3 = logger2;
        Intrinsics.checkNotNullParameter((Object)logger3, (String)"<this>");
        logger3.e("flow wasn't created. flow name can't be empty or null.");
    }

    public static final void logFlowNameTruncated(@NotNull Logger logger2, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"name");
        logger2.w(StringsKt.replace$default((String)"Flow %R was truncated as it was too long. Please limit trace names to 150 characters. please refer to the docs (https://docs.instabug.com/docs/android-app-flows)", (String)"%R", (String)string, (boolean)false, (int)4, null));
    }

    public static final void logAttributeKeyExceededMaxLength(@NotNull Logger logger2, @Nullable String string, @Nullable String string2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"<this>");
        String string3 = "Flow attribute \"%R1\" wasn't added to \"%R2\" as it was too long. Please limit attribute key names to 30 characters.";
        String string4 = "%R1";
        if (string2 == null) {
            string2 = "";
        }
        string2 = StringsKt.replace$default((String)string3, (String)string4, (String)string2, (boolean)false, (int)4, null);
        string3 = "%R2";
        if (string == null) {
            string = "";
        }
        logger2.e(StringsKt.replace$default((String)string2, (String)string3, (String)string, (boolean)false, (int)4, null));
    }

    public static final void logAttributeValueExceededMaxLength(@NotNull Logger logger2, @Nullable String string, @Nullable String string2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"<this>");
        String string3 = "Flow attribute \"%R1\" wasn't added to \"%R2\" as it was too long. Please limit attribute value names to 60 characters.";
        String string4 = "%R1";
        if (string2 == null) {
            string2 = "";
        }
        string2 = StringsKt.replace$default((String)string3, (String)string4, (String)string2, (boolean)false, (int)4, null);
        string3 = "%R2";
        if (string == null) {
            string = "";
        }
        logger2.e(StringsKt.replace$default((String)string2, (String)string3, (String)string, (boolean)false, (int)4, null));
    }

    public static final void logAttributeValueIsEmpty(@NotNull Logger logger2, @Nullable String string, @Nullable String string2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"<this>");
        String string3 = "Flow attribute \"%R1\" wasn't added to \"%R2\". Flow attribute value can't be empty string.";
        String string4 = "%R1";
        if (string2 == null) {
            string2 = "";
        }
        string2 = StringsKt.replace$default((String)string3, (String)string4, (String)string2, (boolean)false, (int)4, null);
        string3 = "%R2";
        if (string == null) {
            string = "";
        }
        logger2.e(StringsKt.replace$default((String)string2, (String)string3, (String)string, (boolean)false, (int)4, null));
    }

    public static final void logAttributeKeyIsNullOrEmpty(@NotNull Logger logger2, @Nullable String string) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"<this>");
        String string2 = "Flow attribute wasn't added to \"%R\". Flow attribute key can't be null or empty string.";
        String string3 = "%R";
        if (string == null) {
            string = "";
        }
        logger2.e(StringsKt.replace$default((String)string2, (String)string3, (String)string, (boolean)false, (int)4, null));
    }

    public static final void logAttributesExceededMaxAllowedCount(@NotNull Logger logger2, @Nullable String string, @Nullable String string2, int n) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"<this>");
        String string3 = "Flow attribute \"%R1\" wasn't added to \"%R2\". Max allowed trace attributes reached. Please note that you can add up to %R3 attributes to the same flow";
        String string4 = "%R1";
        if (string2 == null) {
            string2 = "";
        }
        string2 = StringsKt.replace$default((String)string3, (String)string4, (String)string2, (boolean)false, (int)4, null);
        string3 = "%R2";
        if (string == null) {
            string = "";
        }
        logger2.e(StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)string3, (String)string, (boolean)false, (int)4, null), (String)"%R3", (String)String.valueOf(n), (boolean)false, (int)4, null));
    }

    public static final void logDroppedFlows(@NotNull Logger object, int n) {
        Logger logger2 = object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        object = String.valueOf(n);
        logger2.d(StringsKt.replace$default((String)"Flows dropped count: %R", (String)"%R", (String)object, (boolean)false, (int)4, null));
    }
}

