/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.appflow.configuration;

import com.instabug.apm.appflow.configuration.AppFlowConfigurationProvider;
import com.instabug.apm.configuration.ConfigurationHandler;
import com.instabug.apm.logger.APMLogger;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.extenstions.GenericExtKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0002J\b\u0010\n\u001a\u00020\u0006H\u0016J\f\u0010\u000b\u001a\u00020\u0006*\u00020\bH\u0002J\f\u0010\f\u001a\u00020\u0006*\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/instabug/apm/appflow/configuration/AppFlowConfigurationHandler;", "Lcom/instabug/apm/configuration/ConfigurationHandler;", "configurationProvider", "Lcom/instabug/apm/appflow/configuration/AppFlowConfigurationProvider;", "(Lcom/instabug/apm/appflow/configuration/AppFlowConfigurationProvider;)V", "handleConfigurations", "", "configsJson", "Lorg/json/JSONObject;", "handleNullConfigurationObject", "reset", "cacheAppFlowConfigs", "parseAppFlowConfigs", "instabug-apm_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nAppFlowConfigurationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppFlowConfigurationHandler.kt\ncom/instabug/apm/appflow/configuration/AppFlowConfigurationHandler\n+ 2 GenericExt.kt\ncom/instabug/library/util/extenstions/GenericExtKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n7#2,6:49\n13#2,5:56\n1#3:55\n*S KotlinDebug\n*F\n+ 1 AppFlowConfigurationHandler.kt\ncom/instabug/apm/appflow/configuration/AppFlowConfigurationHandler\n*L\n12#1:49,6\n12#1:56,5\n12#1:55\n*E\n"})
public final class AppFlowConfigurationHandler
implements ConfigurationHandler {
    @NotNull
    private final AppFlowConfigurationProvider configurationProvider;

    public AppFlowConfigurationHandler(@NotNull AppFlowConfigurationProvider appFlowConfigurationProvider) {
        Intrinsics.checkNotNullParameter((Object)appFlowConfigurationProvider, (String)"configurationProvider");
        this.configurationProvider = appFlowConfigurationProvider;
    }

    private final void parseAppFlowConfigs(JSONObject jSONObject) {
        if ((jSONObject = jSONObject.optJSONObject("traces")) != null) {
            boolean bl = jSONObject.optBoolean("enabled", false);
            this.configurationProvider.setFeatureEnabled(bl);
            if (!bl) {
                this.reset();
            } else {
                this.cacheAppFlowConfigs(jSONObject);
            }
        }
    }

    private final void cacheAppFlowConfigs(JSONObject jSONObject) {
        AppFlowConfigurationProvider appFlowConfigurationProvider = ((AppFlowConfigurationHandler)((Object)appFlowConfigurationProvider)).configurationProvider;
        appFlowConfigurationProvider.setAttributesEnabled(jSONObject.optBoolean("attributes_enabled", true));
        appFlowConfigurationProvider.setRequestLimit(jSONObject.optInt("limit_per_request", 200));
        appFlowConfigurationProvider.setStoreLimit(jSONObject.optInt("store_limit", 1000));
        appFlowConfigurationProvider.setAttributesStoreLimit(jSONObject.optInt("store_attributes_limit", 5));
        appFlowConfigurationProvider.setIdlingTimeThresholdMs(jSONObject.optInt("idling_time_threshold_ms", 60000));
    }

    private final void handleNullConfigurationObject() {
        APMLogger.logSDKProtected("Can't parse app flow configurations, object is null.");
        this.reset();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleConfigurations(@Nullable JSONObject object) {
        block7: {
            String string;
            String string2;
            block8: {
                Object object2;
                Throwable throwable2;
                block6: {
                    if (object == null) break block7;
                    string2 = "IBG-Core";
                    string = null;
                    try {
                        // empty try
                    }
                    catch (Throwable throwable2) {
                        break block6;
                    }
                    if (object.has("traces")) {
                        ((AppFlowConfigurationHandler)object2).parseAppFlowConfigs((JSONObject)object);
                    } else {
                        ((AppFlowConfigurationHandler)object2).handleNullConfigurationObject();
                    }
                    object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                    break block8;
                }
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            object = Result.exceptionOrNull-impl((Object)object2);
            if (object != null) {
                String string3 = string2;
                string2 = GenericExtKt.constructErrorMessage(string, (Throwable)object);
                InstabugCore.reportError((Throwable)object, (String)string2);
                InstabugSDKLogger.e((String)string3, (String)string2, (Throwable)object);
            }
            Result.box-impl((Object)object2);
        }
    }

    @Override
    public void reset() {
        this.configurationProvider.reset();
    }
}

