/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm;

import android.app.Activity;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.instabug.apm.APMImplementation;
import com.instabug.apm.appflow.model.AppFlowAttribute;
import com.instabug.apm.attributes.listeners.OnNetworkTraceListener;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.model.EventTimeMetricCapture;
import com.instabug.apm.model.ExecutionTrace;
import com.instabug.apm.model.TimeCaptureBoundModel;
import com.instabug.library.apichecker.APIChecker;
import com.instabug.library.apichecker.VoidRunnable;
import com.instabug.library.logging.listeners.networklogs.NetworkLogListener;

public class APM {
    private static final APMImplementation apmImplementation = ServiceLocator.getApmImplementation();
    private static final Logger apmLogger = ServiceLocator.getApmLogger();

    public static void setEnabled(final boolean bl) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                apmImplementation.setEnabled(bl);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"APM.setEnabled", (VoidRunnable)voidRunnable2);
    }

    public static void setColdAppLaunchEnabled(final boolean bl) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                apmImplementation.setColdAppLaunchEnabled(bl);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"APM.setColdAppLaunchEnabled", (VoidRunnable)voidRunnable2);
    }

    public static void setHotAppLaunchEnabled(final boolean bl) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                apmImplementation.setHotAppLaunchEnabled(bl);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"APM.setHotAppLaunchEnabled", (VoidRunnable)voidRunnable2);
    }

    public static void setWarmAppLaunchEnabled(boolean bl) {
        APIChecker.checkAndRunInExecutor((String)"APM.setWarmAppLaunchEnabled", () -> apmImplementation.setWarmAppLaunchEnabled(bl));
    }

    @Deprecated
    @Nullable
    public static ExecutionTrace startExecutionTrace(@NonNull String string) {
        apmLogger.w("APM.startExecutionTrace is deprecated, Please use APM.startFlow instead.");
        return apmImplementation.startExecutionTrace(string);
    }

    public static void setAutoUITraceEnabled(final boolean bl) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                apmImplementation.setAutoUITraceEnabled(bl);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"APM.setAutoUITraceEnabled", (VoidRunnable)voidRunnable2);
    }

    public static void setUIHangEnabled(final boolean bl) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                apmImplementation.setUIHangEnabled(bl);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"APM.setUIHangEnabled", (VoidRunnable)voidRunnable2);
    }

    public static void setScreenLoadingEnabled(final boolean bl) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                apmImplementation.setScreenLoadingEnabled(bl);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"APM.setScreenLoadingEnabled", (VoidRunnable)voidRunnable2);
    }

    @RequiresApi(api=16)
    public static void startUITrace(final @NonNull String string) {
        VoidRunnable voidRunnable;
        final Looper looper = Looper.myLooper();
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                7 v0 = string2;
                String string2 = v0.string;
                apmImplementation.startUiTrace(string2, v0.looper);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"APM.startUITrace", (VoidRunnable)voidRunnable2);
    }

    @RequiresApi(api=16)
    public static void endUITrace() {
        VoidRunnable voidRunnable;
        final Looper looper = Looper.myLooper();
        if (looper != Looper.getMainLooper()) {
            apmLogger.w("APM.endUITrace was called from a non-main thread. Please make sure to end Custom UI Traces from the main thread.");
        }
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                apmImplementation.endUiTrace(looper);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"APM.endUITrace", (VoidRunnable)voidRunnable2);
    }

    public static void addOnNetworkTraceListener(final OnNetworkTraceListener onNetworkTraceListener) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                apmImplementation.addOnNetworkTraceListener(onNetworkTraceListener);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"APM.addOnNetworkTraceListener", (VoidRunnable)voidRunnable2);
    }

    public static void removeOnNetworkTraceListener(final OnNetworkTraceListener onNetworkTraceListener) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                apmImplementation.removeOnNetworkTraceListener(onNetworkTraceListener);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"APM.removeOnNetworkTraceListener", (VoidRunnable)voidRunnable2);
    }

    public static void endAppLaunch() {
        ServiceLocator.getAppLaunchDataRepository().setAppLaunchEndMicro(System.nanoTime() / 1000L);
        APIChecker.checkAndRunInExecutor((String)"APM.endAppLaunch", apmImplementation::endAppLaunch);
    }

    public static <ActivityType extends Activity> void endScreenLoading(Class<ActivityType> object) {
        EventTimeMetricCapture eventTimeMetricCapture;
        Class<ActivityType> clazz = object;
        object = eventTimeMetricCapture;
        eventTimeMetricCapture = new EventTimeMetricCapture();
        APIChecker.checkAndRunInExecutor((String)"APM.endScreenLoading", () -> APM.lambda$endScreenLoading$1(clazz, (EventTimeMetricCapture)object));
    }

    public static void setFragmentSpansEnabled(boolean bl) {
        APIChecker.checkAndRunInExecutor((String)"APM.setFragmentSpansEnabled", () -> apmImplementation.setFragmentSpansEnabled(bl));
    }

    public static void registerNetworkLogsListener(@Nullable NetworkLogListener networkLogListener) {
        APIChecker.checkAndRunInExecutor((String)"APM.registerNetworkLogsListener", () -> apmImplementation.registerNetworkLogsListener(networkLogListener));
    }

    public static void setComposeSpansEnabled(boolean bl) {
        APIChecker.checkAndRunInExecutor((String)"APM.setComposeSpansEnabled", () -> apmImplementation.setComposeSpansEnabled(bl));
    }

    public static void setWebViewsTrackingEnabled(boolean bl) {
        APIChecker.checkAndRunInExecutor((String)"APM.setWebViewsEnabled", () -> apmImplementation.setWebViewsTrackingEnabled(bl));
    }

    public static void startFlow(@NonNull String string) {
        APIChecker.checkAndRunInExecutor((String)"APM.startFlow", () -> APM.lambda$startFlow$6(new TimeCaptureBoundModel<String>(string)));
    }

    public static void endFlow(@NonNull String string) {
        APIChecker.checkAndRunInExecutor((String)"APM.endFlow", () -> APM.lambda$endFlow$7(new TimeCaptureBoundModel<String>(string)));
    }

    public static void setFlowAttribute(@NonNull String string, @NonNull String string2, String string3) {
        AppFlowAttribute appFlowAttribute;
        AppFlowAttribute appFlowAttribute2 = appFlowAttribute;
        appFlowAttribute = new AppFlowAttribute(string, string2, string3);
        APIChecker.checkAndRunInExecutor((String)"APM.setFlowAttribute", () -> APM.lambda$setFlowAttribute$8(new TimeCaptureBoundModel<AppFlowAttribute>(appFlowAttribute2)));
    }

    private static /* synthetic */ void lambda$setFlowAttribute$8(TimeCaptureBoundModel timeCaptureBoundModel) {
        apmImplementation.setFlowAttribute(timeCaptureBoundModel);
    }

    private static /* synthetic */ void lambda$endFlow$7(TimeCaptureBoundModel timeCaptureBoundModel) {
        apmImplementation.endFlow(timeCaptureBoundModel);
    }

    private static /* synthetic */ void lambda$startFlow$6(TimeCaptureBoundModel timeCaptureBoundModel) {
        apmImplementation.startFlow(timeCaptureBoundModel);
    }

    private static /* synthetic */ void lambda$endScreenLoading$1(Class clazz, EventTimeMetricCapture eventTimeMetricCapture) {
        apmImplementation.endScreenLoading(clazz, eventTimeMetricCapture);
    }
}

