package com.instabug.apm.util.device;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.PowerManager;
import android.view.Display;
import android.view.WindowManager;

import androidx.annotation.Nullable;

import com.instabug.apm.constants.DefaultValues;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.util.DeviceStateProvider;

public class APMDeviceStateProviderImpl implements APMDeviceStateProvider {

    private final static String LANDSCAPE = "landscape";
    private final static String PORTRAIT = "portrait";

    @Override
    public int getBatteryLevel(Context context) {
        return DeviceStateProvider.getBatteryLevel(context);
    }

    @Override
    public int getRefreshRate(Context context) {

        Display display;

        /* Use DeviceManager to avoid android.os.context.getSystemService(Context.WINDOW_SERVICE.IncorrectContextUseViolation when StrictMode is enabled on API 30. */
        if (Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.JELLY_BEAN_MR1) {
            DisplayManager displayManager = (DisplayManager) context.getSystemService(Context.DISPLAY_SERVICE);
            display = displayManager.getDisplay(Display.DEFAULT_DISPLAY);
        } else {
            display = ((WindowManager) context.getSystemService(Context.WINDOW_SERVICE))
                    .getDefaultDisplay();
        }

        if (display != null) {
            return (int) display.getRefreshRate();
        }

        return DefaultValues.UiTraces.DEFAULT_REFRESH_RATE;
    }

    @Override
    @Nullable
    public Boolean isPowerSaveModeEnabled(Context context) {
        PowerManager pm = (PowerManager) context.getSystemService(Context.POWER_SERVICE);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            return pm != null && pm.isPowerSaveMode();
        } else {
            return null;
        }
    }

    @Override
    public String getScreenOrientation(Activity activity) {
        boolean isLandscape = activity.getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE;
        return isLandscape ? LANDSCAPE : PORTRAIT;
    }

    @Override
    public boolean isProbablyAnEmulator() {
        return InstabugDeviceProperties.isProbablyAnEmulator();
    }
}
