package com.instabug.apm.util.device;

import android.app.Activity;
import android.content.Context;

import androidx.annotation.Nullable;

/**
 Gets info about the device, application, and OS.
 */
public interface APMDeviceStateProvider {
    /**
     Gets the current battery level as percentage.

     @param context to get system services

     @return int value of the battery level.
     */
    int getBatteryLevel(Context context);

    /**
     Gets the current screen refreshing rate.
     <p>
     FPS typically is 60 frame per seconds, but some flagship device currently support higher
     refresh rates, and support switching between them according to the app nature.
     </>

     @param context to get system services

     @return int value of the battery level.
     */
    int getRefreshRate(Context context);

    /**
     Gets the current state of power save mode.

     @param context to get system services

     @return boolean value, true if the power save is enabled, false if disabled, and null if not supported (pre API level 21).
     */
    @Nullable
    Boolean isPowerSaveModeEnabled(Context context);

    /**
     Gets the current orientation direction of the screen of power save mode.

     @param activity the activity under test

     @return string value, landscape or portrait.
     */
    String getScreenOrientation(Activity activity);

    /**
     * Checks if SDK is running on an emulator
     * * @return true if running on emulator, false otherwise
     */
    boolean isProbablyAnEmulator();
}
