package com.instabug.apm.uitrace.uihangs

import java.util.concurrent.TimeUnit

interface FrameDropsCalculator {
    fun reset()
    fun calculateFrameDuration(frameTimeNanos: Long, smallDropThreshold: Float): Long?
}

class FrameDropsCalculatorImpl : FrameDropsCalculator {

    private var lastFrameRenderingTimeNanos = -1L
    override fun reset() {
        lastFrameRenderingTimeNanos = -1
    }

    override fun calculateFrameDuration(frameTimeNanos: Long, smallDropThreshold: Float): Long? =
        TimeUnit.NANOSECONDS.toMicros(frameTimeNanos - lastFrameRenderingTimeNanos)
            .takeIf { lastFrameRenderingTimeNanos > 0L }
            ?.takeIf { it > smallDropThreshold }
            .also { lastFrameRenderingTimeNanos = frameTimeNanos }
}
