package com.instabug.apm.handler.executiontraces;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.apm.cache.model.ExecutionTraceCacheModel;
import com.instabug.library.Instabug;

import java.util.List;

public interface ExecutionTracesHandler {

    /**
     * Add new attribute to specific trace
     *
     * @param traceId   id of the associated trace
     * @param traceName name of the associated trace
     * @param key       attribute key
     * @param value     attribute value
     */
    void setAttribute(long traceId, @NonNull String traceName, @NonNull String key, @Nullable String value);

    /**
     * Removes all custom traces with its attributes
     */
    void removeAll();

    /**
     * Removes all un-ended custom traces along side with there attributes
     */
    void removeUnEndedTraces();

    /**
     * Gets list of cached ended custom traces for passed session id
     *
     * @param sessionID id of the session to get cached custom
     *                  traces for
     * @return List of {@link ExecutionTraceCacheModel}
     */
    @Nullable
    List<ExecutionTraceCacheModel> getExecutionTracesForSession(String sessionID);

    /**
     * Removes oldest ExecutionTraces with its attributes till the table reach the count passed
     *
     * @param limit number of traces to be remained
     */
    void trimTracesToLimit(long limit);

    boolean insertTrace(ExecutionTraceCacheModel cacheModel);
}
